/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.converters;

import java.util.List;
import java.util.Locale;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleConverter
implements Converter<Locale> {
    @Override
    public Locale convertFromText(String value, Class<?> requiredType, String optionContext) {
        if (value.length() == 2) {
            return new Locale(value, value.toUpperCase());
        }
        if (value.length() == 5) {
            String[] split = value.split("_");
            return new Locale(split[0], split[1]);
        }
        return null;
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String existingData, String optionContext, MethodTarget target) {
        return false;
    }

    @Override
    public boolean supports(Class<?> requiredType, String optionContext) {
        return Locale.class.isAssignableFrom(requiredType);
    }
}

