/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jline.ANSIBuffer;
import jline.ConsoleReader;
import org.springframework.shell.core.ShellPromptAccessor;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.util.Assert;

public class JLineLogHandler
extends Handler {
    private static final boolean ROO_BRIGHT_COLORS = Boolean.getBoolean("roo.bright");
    private static final boolean SHELL_BRIGHT_COLORS = Boolean.getBoolean("spring.shell.bright");
    private static final boolean BRIGHT_COLORS = ROO_BRIGHT_COLORS || SHELL_BRIGHT_COLORS;
    private ConsoleReader reader;
    private ShellPromptAccessor shellPromptAccessor;
    private static ThreadLocal<Boolean> redrawProhibit = new ThreadLocal();
    private static String lastMessage;
    private static boolean includeThreadName;
    private boolean ansiSupported;
    private String userInterfaceThreadName;
    private static boolean suppressDuplicateMessages;

    public JLineLogHandler(ConsoleReader reader, ShellPromptAccessor shellPromptAccessor) {
        Assert.notNull((Object)reader, (String)"Console reader required");
        Assert.notNull((Object)shellPromptAccessor, (String)"Shell prompt accessor required");
        this.reader = reader;
        this.shellPromptAccessor = shellPromptAccessor;
        this.userInterfaceThreadName = Thread.currentThread().getName();
        this.ansiSupported = reader.getTerminal().isANSISupported();
        this.setFormatter(new Formatter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public String format(LogRecord record) {
                StringBuffer sb = new StringBuffer();
                if (record.getMessage() != null) {
                    sb.append(record.getMessage()).append(OsUtils.LINE_SEPARATOR);
                }
                if (record.getThrown() != null) {
                    PrintWriter pw = null;
                    try {
                        StringWriter sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        record.getThrown().printStackTrace(pw);
                        sb.append(sw.toString());
                    }
                    catch (Exception ex) {
                        IOUtils.closeQuietly(pw);
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(pw);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(pw);
                }
                return sb.toString();
            }
        });
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    public static void prohibitRedraw() {
        redrawProhibit.set(true);
    }

    public static void cancelRedrawProhibition() {
        redrawProhibit.remove();
    }

    public static void setIncludeThreadName(boolean include) {
        includeThreadName = include;
    }

    public static void resetMessageTracking() {
        lastMessage = null;
    }

    public static boolean isSuppressDuplicateMessages() {
        return suppressDuplicateMessages;
    }

    public static void setSuppressDuplicateMessages(boolean suppressDuplicateMessages) {
        JLineLogHandler.suppressDuplicateMessages = suppressDuplicateMessages;
    }

    public void publish(LogRecord record) {
        try {
            String toDisplay = this.toDisplay(record);
            if (toDisplay.equals(lastMessage) && suppressDuplicateMessages) {
                return;
            }
            lastMessage = toDisplay;
            StringBuffer buffer = this.reader.getCursorBuffer().getBuffer();
            int cursor = this.reader.getCursorBuffer().cursor;
            if (this.reader.getCursorBuffer().length() > 0) {
                this.reader.printNewline();
                this.reader.getCursorBuffer().setBuffer(new StringBuffer());
                this.reader.getCursorBuffer().cursor = 0;
            }
            this.reader.setDefaultPrompt("");
            this.reader.redrawLine();
            this.reader.setDefaultPrompt(this.shellPromptAccessor.getShellPrompt());
            this.reader.getCursorBuffer().setBuffer(buffer);
            this.reader.getCursorBuffer().cursor = cursor;
            this.reader.printString(toDisplay);
            Boolean prohibitingRedraw = redrawProhibit.get();
            if (prohibitingRedraw == null) {
                this.reader.redrawLine();
            }
            this.reader.flushConsole();
        }
        catch (Exception e) {
            this.reportError("Could not publish log message", e, Level.SEVERE.intValue());
        }
    }

    private String toDisplay(LogRecord event) {
        String eventString;
        String threadName;
        StringBuilder sb = new StringBuilder();
        if (includeThreadName && !this.userInterfaceThreadName.equals(Thread.currentThread().getName()) && !"".equals(Thread.currentThread().getName())) {
            threadName = "[" + Thread.currentThread().getName() + "]";
            StringBuilder lineSeparatorAndIndentingString = new StringBuilder();
            for (int i = 0; i <= threadName.length(); ++i) {
                lineSeparatorAndIndentingString.append(" ");
            }
            eventString = " " + this.getFormatter().format(event).replace(OsUtils.LINE_SEPARATOR, OsUtils.LINE_SEPARATOR + lineSeparatorAndIndentingString.toString());
            if (eventString.endsWith(lineSeparatorAndIndentingString.toString())) {
                eventString = eventString.substring(0, eventString.length() - lineSeparatorAndIndentingString.length());
            }
        } else {
            threadName = "";
            eventString = this.getFormatter().format(event);
        }
        if (this.ansiSupported) {
            if (event.getLevel().intValue() >= Level.SEVERE.intValue()) {
                sb.append(JLineLogHandler.getANSIBuffer().reverse(threadName).red(eventString));
            } else if (event.getLevel().intValue() >= Level.WARNING.intValue()) {
                sb.append(JLineLogHandler.getANSIBuffer().reverse(threadName).magenta(eventString));
            } else if (event.getLevel().intValue() >= Level.INFO.intValue()) {
                sb.append(JLineLogHandler.getANSIBuffer().reverse(threadName).green(eventString));
            } else {
                sb.append(JLineLogHandler.getANSIBuffer().reverse(threadName).append(eventString));
            }
        } else {
            sb.append(threadName).append(eventString);
        }
        return sb.toString();
    }

    public static ANSIBuffer getANSIBuffer() {
        int esc = 27;
        return new ANSIBuffer(){

            public ANSIBuffer reverse(String str) {
                if (OsUtils.isWindows()) {
                    return super.reverse(str).append(ANSIBuffer.ANSICodes.attrib((int)27));
                }
                return super.reverse(str);
            }

            public ANSIBuffer attrib(String str, int code) {
                if (BRIGHT_COLORS && 30 <= code && code <= 37) {
                    return this.append("\u001b[" + code + ";1m").append(str).append(ANSIBuffer.ANSICodes.attrib((int)0));
                }
                return super.attrib(str, code);
            }
        };
    }

    static {
        includeThreadName = false;
        suppressDuplicateMessages = true;
    }
}

