/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.ANSIBuffer;
import jline.Completor;
import jline.ConsoleReader;
import jline.Terminal;
import jline.WindowsTerminal;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.springframework.shell.core.AbstractShell;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.JLineCompletorAdapter;
import org.springframework.shell.core.JLineLogHandler;
import org.springframework.shell.core.Shell;
import org.springframework.shell.event.ShellStatus;
import org.springframework.shell.event.ShellStatusListener;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.shell.support.util.VersionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class JLineShell
extends AbstractShell
implements CommandMarker,
Shell,
Runnable {
    private static final String ANSI_CONSOLE_CLASSNAME = "org.fusesource.jansi.AnsiConsole";
    private static final boolean JANSI_AVAILABLE = ClassUtils.isPresent((String)"org.fusesource.jansi.AnsiConsole", (ClassLoader)JLineShell.class.getClassLoader());
    private static final boolean APPLE_TERMINAL = Boolean.getBoolean("is.apple.terminal");
    private static final char ESCAPE = '\u001b';
    private static final String BEL = "\u0007";
    protected ConsoleReader reader;
    private boolean developmentMode = false;
    private FileWriter fileLog;
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected ShellStatusListener statusListener;
    private final Map<String, FlashInfo> flashInfoMap = new HashMap<String, FlashInfo>();
    private final Map<Integer, Integer> rowErasureMap = new HashMap<Integer, Integer>();
    private boolean shutdownHookFired = false;
    private int historySize;

    public void run() {
        String[] filteredLogEntries;
        this.reader = this.createConsoleReader();
        this.setPromptPath(null);
        JLineLogHandler handler = new JLineLogHandler(this.reader, this);
        JLineLogHandler.prohibitRedraw();
        Logger mainLogger = Logger.getLogger("");
        this.removeHandlers(mainLogger);
        mainLogger.addHandler(handler);
        this.reader.addCompletor((Completor)new JLineCompletorAdapter(this.getParser()));
        this.reader.setBellEnabled(true);
        if (Boolean.getBoolean("jline.nobell")) {
            this.reader.setBellEnabled(false);
        }
        this.openFileLogIfPossible();
        this.reader.getHistory().setMaxSize(this.getHistorySize());
        for (String logEntry : filteredLogEntries = this.filterLogEntry()) {
            this.reader.getHistory().addToHistory(logEntry);
        }
        this.flashMessageRenderer();
        this.flash(Level.FINE, this.getProductName() + " " + this.getVersion(), "WINDOW_TITLE_SLOT");
        this.printBannerAndWelcome();
        String startupNotifications = this.getStartupNotifications();
        if (StringUtils.hasText((String)startupNotifications)) {
            this.logger.info(startupNotifications);
        }
        this.setShellStatus(ShellStatus.Status.STARTED);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    JLineShell.this.shutdownHookFired = true;
                }
            }, this.getProductName() + " JLine Shutdown Hook"));
        }
        catch (Throwable t) {
            // empty catch block
        }
        String rooArgs = System.getProperty("roo.args");
        if (rooArgs != null && !"".equals(rooArgs)) {
            this.setShellStatus(ShellStatus.Status.USER_INPUT);
            boolean success = this.executeCommand(rooArgs);
            if (this.exitShellRequest == null) {
                this.executeCommand("quit");
                this.exitShellRequest = success ? ExitShellRequest.NORMAL_EXIT : ExitShellRequest.FATAL_EXIT;
            }
            this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
        } else {
            this.promptLoop();
        }
    }

    private String[] filterLogEntry() {
        ArrayList<String> entries = new ArrayList<String>();
        try {
            ReversedLinesFileReader reader = new ReversedLinesFileReader(new File(this.getHistoryFileName()), 4096, Charset.forName("UTF-8"));
            int size = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//")) continue;
                if (++size <= this.historySize) {
                    entries.add(line);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.warning("read history file failed. Reason:" + e.getMessage());
        }
        Collections.reverse(entries);
        return entries.toArray(new String[0]);
    }

    protected ConsoleReader createConsoleReader() {
        ConsoleReader consoleReader = null;
        try {
            if (this.isJansiAvailable()) {
                try {
                    consoleReader = this.createAnsiWindowsReader();
                }
                catch (Exception e) {
                    this.logger.warning("Can't initialize jansi AnsiConsole, falling back to default: " + e);
                }
            }
            if (consoleReader == null) {
                consoleReader = new ConsoleReader();
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot start console class", ioe);
        }
        return consoleReader;
    }

    private boolean isJansiAvailable() {
        return JANSI_AVAILABLE && OsUtils.isWindows() && System.getProperty("jline.terminal") == null;
    }

    public void printBannerAndWelcome() {
    }

    public String getStartupNotifications() {
        return null;
    }

    private void removeHandlers(Logger l) {
        Handler[] handlers = l.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                l.removeHandler(h);
            }
        }
    }

    public void setPromptPath(String path) {
        this.setPromptPath(path, false);
    }

    public void setPromptPath(String path, boolean overrideStyle) {
        if (this.reader.getTerminal().isANSISupported()) {
            ANSIBuffer ansi = JLineLogHandler.getANSIBuffer();
            if (path == null || "".equals(path)) {
                shellPrompt = ansi.yellow(this.getPromptText()).toString();
            } else {
                if (overrideStyle) {
                    ansi.append(path);
                } else {
                    ansi.cyan(path);
                }
                shellPrompt = ansi.yellow(" " + this.getPromptText()).toString();
            }
        } else {
            super.setPromptPath(path);
        }
        this.reader.setDefaultPrompt(shellPrompt);
    }

    protected ConsoleReader createAnsiWindowsReader() throws Exception {
        final PrintStream ansiOut = (PrintStream)ClassUtils.forName((String)ANSI_CONSOLE_CLASSNAME, (ClassLoader)JLineShell.class.getClassLoader()).getMethod("out", new Class[0]).invoke(null, new Object[0]);
        WindowsTerminal ansiTerminal = new WindowsTerminal(){

            public boolean isANSISupported() {
                return true;
            }
        };
        ansiTerminal.initializeTerminal();
        this.statusListener = new ShellStatusListener(){

            public void onShellStatusChange(ShellStatus oldStatus, ShellStatus newStatus) {
                if (newStatus.getStatus().equals((Object)ShellStatus.Status.SHUTTING_DOWN)) {
                    ansiOut.close();
                }
            }
        };
        this.addShellStatusListener(this.statusListener);
        return new ConsoleReader((InputStream)new FileInputStream(FileDescriptor.in), (Writer)new PrintWriter(new OutputStreamWriter((OutputStream)ansiOut, System.getProperty("jline.WindowsTerminal.output.encoding", "Cp850"))), null, (Terminal)ansiTerminal);
    }

    private void flashMessageRenderer() {
        if (!this.reader.getTerminal().isANSISupported()) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!JLineShell.this.shellStatus.getStatus().equals((Object)ShellStatus.Status.SHUTTING_DOWN) && !JLineShell.this.shutdownHookFired) {
                    Map map = JLineShell.this.flashInfoMap;
                    synchronized (map) {
                        long now = System.currentTimeMillis();
                        HashSet<String> toRemove = new HashSet<String>();
                        for (String slot : JLineShell.this.flashInfoMap.keySet()) {
                            FlashInfo flashInfo = (FlashInfo)JLineShell.this.flashInfoMap.get(slot);
                            if (flashInfo.flashMessageUntil < now) {
                                toRemove.add(slot);
                                JLineShell.this.doAnsiFlash(flashInfo.rowNumber, Level.ALL, "");
                                continue;
                            }
                            JLineShell.this.doAnsiFlash(flashInfo.rowNumber, flashInfo.flashLevel, flashInfo.flashMessage);
                        }
                        for (String slot : toRemove) {
                            JLineShell.this.flashInfoMap.remove(slot);
                        }
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, this.getProductName() + " JLine Flash Message Manager");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flash(Level level, String message, String slot) {
        Assert.notNull((Object)level, (String)"Level is required for a flash message");
        Assert.notNull((Object)message, (String)"Message is required for a flash message");
        Assert.hasText((String)slot, (String)"Slot name must be specified for a flash message");
        if ("WINDOW_TITLE_SLOT".equals(slot)) {
            if (this.reader != null && this.reader.getTerminal().isANSISupported()) {
                if (!StringUtils.hasText((String)message)) {
                    System.out.println("No text");
                }
                ANSIBuffer buff = JLineLogHandler.getANSIBuffer();
                buff.append("\u001b]0;").append(message).append(BEL);
                String stg = buff.toString();
                try {
                    this.reader.printString(stg);
                    this.reader.flushConsole();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return;
        }
        if (this.reader != null && !this.reader.getTerminal().isANSISupported()) {
            super.flash(level, message, slot);
            return;
        }
        Map<String, FlashInfo> map = this.flashInfoMap;
        synchronized (map) {
            FlashInfo flashInfo = this.flashInfoMap.get(slot);
            if ("".equals(message)) {
                if (flashInfo == null) {
                    return;
                }
                flashInfo.flashMessageUntil = System.currentTimeMillis() + 1500L;
            } else {
                if (flashInfo == null) {
                    flashInfo = new FlashInfo();
                    flashInfo.rowNumber = Integer.MAX_VALUE;
                    block5: for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                        for (FlashInfo existingFlashInfo : this.flashInfoMap.values()) {
                            if (existingFlashInfo.rowNumber != i) continue;
                            continue block5;
                        }
                        flashInfo.rowNumber = i;
                        break;
                    }
                    this.flashInfoMap.put(slot, flashInfo);
                }
                flashInfo.flashMessageUntil = Long.MAX_VALUE;
                flashInfo.flashLevel = level;
                flashInfo.flashMessage = message;
                this.doAnsiFlash(flashInfo.rowNumber, flashInfo.flashLevel, flashInfo.flashMessage);
            }
        }
    }

    private void doAnsiFlash(int row, Level level, String message) {
        ANSIBuffer buff = JLineLogHandler.getANSIBuffer();
        if (APPLE_TERMINAL) {
            buff.append("\u001b7");
        } else {
            buff.append(ANSIBuffer.ANSICodes.save());
        }
        int mostFurtherLeftColNumber = Integer.MAX_VALUE;
        for (Integer candidate : this.rowErasureMap.values()) {
            if (candidate >= mostFurtherLeftColNumber) continue;
            mostFurtherLeftColNumber = candidate;
        }
        if (mostFurtherLeftColNumber != Integer.MAX_VALUE) {
            buff.append(ANSIBuffer.ANSICodes.gotoxy((int)row, (int)mostFurtherLeftColNumber));
            buff.append(ANSIBuffer.ANSICodes.clreol());
        }
        if ("".equals(message)) {
            this.rowErasureMap.remove(row);
        } else {
            if (this.shutdownHookFired) {
                return;
            }
            int startFrom = this.reader.getTermwidth() - message.length() + 1;
            if (startFrom < 1) {
                startFrom = 1;
            }
            buff.append(ANSIBuffer.ANSICodes.gotoxy((int)row, (int)startFrom));
            buff.reverse(message);
            this.rowErasureMap.put(row, startFrom);
        }
        if (APPLE_TERMINAL) {
            buff.append("\u001b8");
        } else {
            buff.append(ANSIBuffer.ANSICodes.restore());
        }
        String stg = buff.toString();
        try {
            this.reader.printString(stg);
            this.reader.flushConsole();
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    public void promptLoop() {
        this.setShellStatus(ShellStatus.Status.USER_INPUT);
        String prompt = this.getPromptText();
        try {
            String line;
            while (this.exitShellRequest == null && this.reader != null && (line = this.reader.readLine()) != null) {
                JLineLogHandler.resetMessageTracking();
                this.setShellStatus(ShellStatus.Status.USER_INPUT);
                if ("".equals(line)) continue;
                this.executeCommand(line);
                String newPrmpt = this.getPromptText();
                if (ObjectUtils.nullSafeEquals((Object)prompt, (Object)newPrmpt)) continue;
                prompt = newPrmpt;
                this.setPromptPath(null);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Shell line reading failure", ioe);
        }
        this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
    }

    public void setDevelopmentMode(boolean developmentMode) {
        JLineLogHandler.setIncludeThreadName(developmentMode);
        JLineLogHandler.setSuppressDuplicateMessages(!developmentMode);
        this.developmentMode = developmentMode;
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    private void openFileLogIfPossible() {
        try {
            this.fileLog = new FileWriter(this.getHistoryFileName(), true);
            this.fileLog.write("// " + this.getProductName() + " " + this.versionInfo() + " log opened at " + this.df.format(new Date()) + "\n");
            this.fileLog.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void logCommandToOutput(String processedLine) {
        if (this.fileLog == null) {
            this.openFileLogIfPossible();
            if (this.fileLog == null) {
                return;
            }
        }
        try {
            this.fileLog.write(processedLine + "\n");
            this.fileLog.flush();
            if (this.getExitShellRequest() != null) {
                this.fileLog.write("// " + this.getProductName() + " " + this.versionInfo() + " log closed at " + this.df.format(new Date()) + "\n");
                IOUtils.closeQuietly(this.fileLog);
                this.fileLog = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getHomeAsString() {
        String rooHome = System.getProperty("roo.home");
        if (rooHome == null) {
            try {
                rooHome = new File(".").getCanonicalPath();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return rooHome;
    }

    protected void closeShell() {
        this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
        if (this.statusListener != null) {
            this.removeShellStatusListener(this.statusListener);
        }
    }

    protected abstract String getHistoryFileName();

    protected abstract String getPromptText();

    protected abstract String getProductName();

    protected String getVersion() {
        return VersionUtils.versionInfo();
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    private static class FlashInfo {
        String flashMessage;
        long flashMessageUntil;
        Level flashLevel;
        int rowNumber;

        private FlashInfo() {
        }
    }
}

