/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    private ParserUtils() {
    }

    public static Map<String, String> tokenize(String remainingBuffer) {
        Assert.notNull((Object)remainingBuffer, (String)"Remaining buffer cannot be null, although it can be empty");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringBuilder currentOption = new StringBuilder();
        StringBuilder currentValue = new StringBuilder();
        boolean inQuotes = false;
        int count = 0;
        for (char c : remainingBuffer.toCharArray()) {
            if ('\"' != c) continue;
            ++count;
        }
        Assert.isTrue((count % 2 == 0 ? 1 : 0) != 0, (String)"Cannot have an unbalanced number of quotation marks");
        if ("".equals(remainingBuffer.trim())) {
            return result;
        }
        String[] split = remainingBuffer.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String currentToken = split[i];
            if (currentToken.startsWith("\"") && currentToken.endsWith("\"") && currentToken.length() > 1) {
                String tokenLessDelimiters = currentToken.substring(1, currentToken.length() - 1);
                currentValue.append(tokenLessDelimiters);
                ParserUtils.store(result, currentOption, currentValue);
                currentOption = new StringBuilder();
                currentValue = new StringBuilder();
                continue;
            }
            if (inQuotes) {
                if (currentToken.endsWith("\"")) {
                    String tokenLessDelimiters = currentToken.substring(0, currentToken.length() - 1);
                    currentValue.append(" ").append(tokenLessDelimiters);
                    inQuotes = false;
                    ParserUtils.store(result, currentOption, currentValue);
                    currentOption = new StringBuilder();
                    currentValue = new StringBuilder();
                    continue;
                }
                currentValue.append(" ").append(currentToken);
                continue;
            }
            if (currentToken.startsWith("\"")) {
                String tokenLessDelimiters = currentToken.substring(1);
                currentValue.append(tokenLessDelimiters);
                inQuotes = true;
                continue;
            }
            if (currentToken.trim().equals("")) continue;
            if (currentToken.startsWith("--")) {
                int lastIndex = currentToken.lastIndexOf("-");
                String tokenLessDelimiters = currentToken.substring(lastIndex + 1);
                currentOption.append(tokenLessDelimiters);
                if (i + 1 == split.length) {
                    ParserUtils.store(result, currentOption, currentValue);
                    break;
                }
                if (!split[i + 1].startsWith("-")) continue;
                ParserUtils.store(result, currentOption, currentValue);
                currentOption = new StringBuilder();
                currentValue = new StringBuilder();
                continue;
            }
            if (currentOption.length() == 0) {
                if (currentValue.length() > 0) {
                    currentValue.append(" ");
                }
                currentValue.append(currentToken);
                if (i + 1 == split.length) {
                    ParserUtils.store(result, currentOption, currentValue);
                    break;
                }
                if (!split[i + 1].startsWith("--")) continue;
                ParserUtils.store(result, currentOption, currentValue);
                currentOption = new StringBuilder();
                currentValue = new StringBuilder();
                continue;
            }
            currentValue.append(currentToken);
            ParserUtils.store(result, currentOption, currentValue);
            currentOption = new StringBuilder();
            currentValue = new StringBuilder();
        }
        if (result.containsKey("") && ((String)result.get("")).trim().equals("")) {
            result.remove("");
        }
        return result;
    }

    private static void store(Map<String, String> results, StringBuilder currentOption, StringBuilder currentValue) {
        if (currentOption.length() > 0) {
            String option = currentOption.toString();
            Assert.isTrue((!results.containsKey(option) ? 1 : 0) != 0, (String)("You cannot specify option '" + option + "' more than once in a single command"));
            results.put(option, currentValue.toString());
        } else {
            Assert.isTrue((!results.containsKey("") ? 1 : 0) != 0, (String)("You cannot add more than one default option ('" + currentValue.toString() + "') in a single command"));
            results.put("", currentValue.toString());
        }
    }
}

