/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AnsiEscapeCode {
    BLINK(5),
    BOLD(1),
    CONCEALED(8),
    FG_BLACK(30),
    FG_BLUE(34),
    FG_CYAN(36),
    FG_GREEN(32),
    FG_MAGENTA(35),
    FG_RED(31),
    FG_YELLOW(33),
    FG_WHITE(37),
    OFF(0),
    REVERSE(7),
    UNDERSCORE(4);

    private static final boolean ANSI_SUPPORTED;
    private static final char ESC = '\u001b';
    final String code;

    public static String decorate(String text, AnsiEscapeCode ... codes) {
        if (text == null || "".equals(text)) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        if (ANSI_SUPPORTED) {
            for (AnsiEscapeCode code : codes) {
                sb.append(code.code);
            }
        }
        sb.append(text);
        if (codes != null && codes.length > 0 && ANSI_SUPPORTED) {
            sb.append(AnsiEscapeCode.OFF.code);
        }
        return sb.toString();
    }

    private AnsiEscapeCode(int code) {
        this.code = "\u001b[" + code + "m";
    }

    static {
        ANSI_SUPPORTED = Boolean.getBoolean("roo.console.ansi");
    }
}

