/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.config.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.social.connect.jdbc.JdbcUsersConnectionRepository;

public abstract class JdbcConnectionRepositoryConfigSupport {
    private static final Log logger = LogFactory.getLog(JdbcConnectionRepositoryConfigSupport.class);
    private static final String USER_ID_STRING_ID = "__userIdString";
    private static final String CREATE_CONNECTION_REPOSITORY_METHOD_NAME = "createConnectionRepository";

    public BeanDefinition registerJdbcConnectionRepositoryBeans(BeanDefinitionRegistry registry, String connectionRepositoryId, String usersConnectionRepositoryId, String connectionFactoryLocatorRef, String dataSourceRef, String encryptorRef, String userIdSourceRef) {
        this.registerUsersConnectionRepositoryBeanDefinition(registry, usersConnectionRepositoryId, connectionFactoryLocatorRef, dataSourceRef, encryptorRef);
        this.registerUserIdBeanDefinition(registry, userIdSourceRef);
        return this.registerConnectionRepository(registry, usersConnectionRepositoryId, connectionRepositoryId);
    }

    private BeanDefinition registerUsersConnectionRepositoryBeanDefinition(BeanDefinitionRegistry registry, String usersConnectionRepositoryId, String connectionFactoryLocatorRef, String dataSourceRef, String encryptorRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registering JdbcUsersConnectionRepository bean");
        }
        AbstractBeanDefinition usersConnectionRepositoryBD = BeanDefinitionBuilder.genericBeanDefinition(JdbcUsersConnectionRepository.class).addConstructorArgReference(dataSourceRef).addConstructorArgReference(connectionFactoryLocatorRef).addConstructorArgReference(encryptorRef).getBeanDefinition();
        BeanDefinition scopedProxyBean = this.decorateWithScopedProxy(usersConnectionRepositoryId, (BeanDefinition)usersConnectionRepositoryBD, registry);
        registry.registerBeanDefinition(usersConnectionRepositoryId, scopedProxyBean);
        return scopedProxyBean;
    }

    private BeanDefinition registerUserIdBeanDefinition(BeanDefinitionRegistry registry, String userIdSourceRef) {
        AbstractBeanDefinition userIdStringDB = BeanDefinitionBuilder.genericBeanDefinition().getBeanDefinition();
        userIdStringDB.setFactoryBeanName(userIdSourceRef);
        userIdStringDB.setFactoryMethodName("getUserId");
        userIdStringDB.setScope("request");
        registry.registerBeanDefinition(USER_ID_STRING_ID, (BeanDefinition)userIdStringDB);
        return userIdStringDB;
    }

    private BeanDefinition registerConnectionRepository(BeanDefinitionRegistry registry, String usersConnectionRepositoryId, String connectionRepositoryId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registering JdbcConnectionRepository bean");
        }
        AbstractBeanDefinition connectionRepositoryBD = BeanDefinitionBuilder.genericBeanDefinition().addConstructorArgReference(USER_ID_STRING_ID).getBeanDefinition();
        connectionRepositoryBD.setFactoryBeanName(usersConnectionRepositoryId);
        connectionRepositoryBD.setFactoryMethodName(CREATE_CONNECTION_REPOSITORY_METHOD_NAME);
        connectionRepositoryBD.setScope("request");
        registry.registerBeanDefinition(connectionRepositoryId, this.decorateWithScopedProxy(connectionRepositoryId, (BeanDefinition)connectionRepositoryBD, registry));
        return connectionRepositoryBD;
    }

    private BeanDefinition decorateWithScopedProxy(String beanName, BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
        return ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)registry, (boolean)false).getBeanDefinition();
    }
}

