/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookCookieParser {
    public static Map<String, String> getFacebookCookieData(Cookie[] cookies, String appId, String appSecret) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("fbs_" + appId)) continue;
                Map<String, String> cookieData = FacebookCookieParser.extractDataFromCookie(cookie.getValue().trim());
                if (!FacebookCookieParser.calculateSignature(appSecret, cookieData).equals(cookieData.get("sig"))) break;
                return cookieData;
            }
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> extractDataFromCookie(String cookieValue) {
        String[] fields;
        HashMap<String, String> data = new HashMap<String, String>();
        for (String field : fields = cookieValue.split("\\&")) {
            String[] keyValue = field.split("\\=");
            try {
                data.put(keyValue[0], URLDecoder.decode(keyValue[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException wontHappen) {
                // empty catch block
            }
        }
        return data;
    }

    private static String calculateSignature(String appSecret, Map<String, String> cookieData) {
        String payload = "";
        ArrayList<String> keys = new ArrayList<String>(cookieData.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            if (key.equals("sig")) continue;
            payload = payload + key + "=" + cookieData.get(key);
        }
        return FacebookCookieParser.md5(payload + appSecret);
    }

    private static String md5(String in) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(in.getBytes("UTF-8"));
            StringBuffer sb = new StringBuffer();
            for (byte b : hash) {
                if (b >= 0 && b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException wontHappen) {
            return null;
        }
        catch (UnsupportedEncodingException wontHappen) {
            return null;
        }
    }

    private FacebookCookieParser() {
    }
}

