/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.Event;
import org.springframework.social.facebook.api.EventInvitee;
import org.springframework.social.facebook.api.EventOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.Invitation;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventTemplate
extends AbstractFacebookOperations
implements EventOperations {
    private final GraphApi graphApi;

    public EventTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public List<Invitation> getInvitations() {
        return this.getInvitations("me", 0, 25);
    }

    @Override
    public List<Invitation> getInvitations(int offset, int limit) {
        return this.getInvitations("me", offset, limit);
    }

    @Override
    public List<Invitation> getInvitations(String userId) {
        return this.getInvitations(userId, 0, 25);
    }

    @Override
    public List<Invitation> getInvitations(String userId, int offset, int limit) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"offset", (Object)String.valueOf(offset));
        parameters.set((Object)"limit", (Object)String.valueOf(limit));
        return this.graphApi.fetchConnections(userId, "events", Invitation.class, (MultiValueMap<String, String>)parameters);
    }

    @Override
    public Event getEvent(String eventId) {
        return this.graphApi.fetchObject(eventId, Event.class);
    }

    @Override
    public byte[] getEventImage(String eventId) {
        return this.getEventImage(eventId, ImageType.NORMAL);
    }

    @Override
    public byte[] getEventImage(String eventId, ImageType imageType) {
        return this.graphApi.fetchImage(eventId, "picture", imageType);
    }

    @Override
    public String createEvent(String name, String startTime, String endTime) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"name", (Object)name);
        data.set((Object)"start_time", (Object)startTime);
        data.set((Object)"end_time", (Object)endTime);
        return this.graphApi.publish("me", "events", (MultiValueMap<String, Object>)data);
    }

    @Override
    public void deleteEvent(String eventId) {
        this.requireAuthorization();
        this.graphApi.delete(eventId);
    }

    @Override
    public List<EventInvitee> getInvited(String eventId) {
        return this.graphApi.fetchConnections(eventId, "invited", EventInvitee.class, new String[0]);
    }

    @Override
    public List<EventInvitee> getAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "attending", EventInvitee.class, new String[0]);
    }

    @Override
    public List<EventInvitee> getMaybeAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "maybe", EventInvitee.class, new String[0]);
    }

    @Override
    public List<EventInvitee> getNoReplies(String eventId) {
        return this.graphApi.fetchConnections(eventId, "noreply", EventInvitee.class, new String[0]);
    }

    @Override
    public List<EventInvitee> getDeclined(String eventId) {
        return this.graphApi.fetchConnections(eventId, "declined", EventInvitee.class, new String[0]);
    }

    @Override
    public void acceptInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "attending", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void maybeInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "maybe", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void declineInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "declined", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public List<Event> search(String query) {
        return this.search(query, 0, 25);
    }

    @Override
    public List<Event> search(String query, int offset, int limit) {
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"event");
        queryMap.add((Object)"offset", (Object)String.valueOf(offset));
        queryMap.add((Object)"limit", (Object)String.valueOf(limit));
        return this.graphApi.fetchConnections("search", null, Event.class, (MultiValueMap<String, String>)queryMap);
    }
}

