/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.facebook.api.FacebookLink;
import org.springframework.social.facebook.api.FeedOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.LinkPost;
import org.springframework.social.facebook.api.NotePost;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.Post;
import org.springframework.social.facebook.api.StatusPost;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FeedTemplate
extends AbstractFacebookOperations
implements FeedOperations {
    private static final PagingParameters FIRST_PAGE = new PagingParameters(25, null, null, null);
    private final GraphApi graphApi;
    private ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public FeedTemplate(GraphApi graphApi, RestTemplate restTemplate, ObjectMapper objectMapper, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    @Override
    public PagedList<Post> getFeed() {
        return this.getFeed("me", FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getFeed(int offset, int limit) {
        return this.getFeed("me", offset, limit);
    }

    @Override
    public PagedList<Post> getFeed(PagingParameters pagedListParameters) {
        return this.getFeed("me", pagedListParameters);
    }

    @Override
    public PagedList<Post> getFeed(String ownerId) {
        return this.getFeed(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getFeed(String ownerId, int offset, int limit) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/feed", offset, limit);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> getFeed(String ownerId, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/feed", pagedListParameters);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> getHomeFeed() {
        return this.getHomeFeed(FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getHomeFeed(int offset, int limit) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/me/home", offset, limit);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> getHomeFeed(PagingParameters pagedListParameters) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/me/home", pagedListParameters);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<StatusPost> getStatuses() {
        return this.getStatuses("me", FIRST_PAGE);
    }

    @Override
    public PagedList<StatusPost> getStatuses(int offset, int limit) {
        return this.getStatuses("me", offset, limit);
    }

    @Override
    public PagedList<StatusPost> getStatuses(PagingParameters pagedListParameters) {
        return this.getStatuses("me", pagedListParameters);
    }

    @Override
    public PagedList<StatusPost> getStatuses(String userId) {
        return this.getStatuses(userId, FIRST_PAGE);
    }

    @Override
    public PagedList<StatusPost> getStatuses(String userId, int offset, int limit) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + userId + "/statuses", offset, limit);
        return this.deserializeList(responseNode, "status", StatusPost.class);
    }

    @Override
    public PagedList<StatusPost> getStatuses(String userId, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + userId + "/statuses", pagedListParameters);
        return this.deserializeList(responseNode, "status", StatusPost.class);
    }

    @Override
    public PagedList<LinkPost> getLinks() {
        return this.getLinks("me", FIRST_PAGE);
    }

    @Override
    public PagedList<LinkPost> getLinks(int offset, int limit) {
        return this.getLinks("me", offset, limit);
    }

    @Override
    public PagedList<LinkPost> getLinks(PagingParameters pagedListParameters) {
        return this.getLinks("me", pagedListParameters);
    }

    @Override
    public PagedList<LinkPost> getLinks(String ownerId) {
        return this.getLinks(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<LinkPost> getLinks(String ownerId, int offset, int limit) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/links", offset, limit);
        return this.deserializeList(responseNode, "link", LinkPost.class);
    }

    @Override
    public PagedList<LinkPost> getLinks(String ownerId, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/links", pagedListParameters);
        return this.deserializeList(responseNode, "link", LinkPost.class);
    }

    @Override
    public PagedList<NotePost> getNotes() {
        return this.getNotes("me", FIRST_PAGE);
    }

    @Override
    public PagedList<NotePost> getNotes(int offset, int limit) {
        return this.getNotes("me", offset, limit);
    }

    @Override
    public PagedList<NotePost> getNotes(PagingParameters pagedListParameters) {
        return this.getNotes("me", pagedListParameters);
    }

    @Override
    public PagedList<NotePost> getNotes(String ownerId) {
        return this.getNotes(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<NotePost> getNotes(String ownerId, int offset, int limit) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/notes", offset, limit);
        return this.deserializeList(responseNode, "note", NotePost.class);
    }

    @Override
    public PagedList<NotePost> getNotes(String ownerId, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/notes", pagedListParameters);
        return this.deserializeList(responseNode, "note", NotePost.class);
    }

    @Override
    public PagedList<Post> getPosts() {
        return this.getPosts("me", FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getPosts(int offset, int limit) {
        return this.getPosts("me", offset, limit);
    }

    @Override
    public PagedList<Post> getPosts(PagingParameters pagedListParameters) {
        return this.getPosts("me", pagedListParameters);
    }

    @Override
    public PagedList<Post> getPosts(String ownerId) {
        return this.getPosts(ownerId, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> getPosts(String ownerId, int offset, int limit) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/posts", offset, limit);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> getPosts(String ownerId, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        JsonNode responseNode = this.fetchConnectionList("https://graph.facebook.com/" + ownerId + "/posts", pagedListParameters);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public Post getPost(String entryId) {
        this.requireAuthorization();
        ObjectNode responseNode = (ObjectNode)this.restTemplate.getForObject("https://graph.facebook.com/" + entryId, JsonNode.class, new Object[0]);
        return this.deserializePost(null, Post.class, responseNode);
    }

    @Override
    public String updateStatus(String message) {
        return this.post("me", message);
    }

    @Override
    public String postLink(String message, FacebookLink link) {
        return this.postLink("me", message, link);
    }

    @Override
    public String postLink(String ownerId, String message, FacebookLink link) {
        this.requireAuthorization();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"link", (Object)link.getLink());
        map.set((Object)"name", (Object)link.getName());
        map.set((Object)"caption", (Object)link.getCaption());
        map.set((Object)"description", (Object)link.getDescription());
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(ownerId, "feed", (MultiValueMap<String, Object>)map);
    }

    @Override
    public String post(String ownerId, String message) {
        this.requireAuthorization();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(ownerId, "feed", (MultiValueMap<String, Object>)map);
    }

    @Override
    public void deletePost(String id) {
        this.requireAuthorization();
        this.graphApi.delete(id);
    }

    @Override
    public PagedList<Post> searchPublicFeed(String query) {
        return this.searchPublicFeed(query, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> searchPublicFeed(String query, int offset, int limit) {
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject("https://graph.facebook.com/search?q={query}&type=post&offset={offset}&limit={limit}", JsonNode.class, new Object[]{query, offset, limit});
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> searchPublicFeed(String query, PagingParameters pagedListParameters) {
        String url = "https://graph.facebook.com/search?q={query}&type=post";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        if (pagedListParameters.getLimit() != null) {
            url = url + "&limit={limit}";
            params.put("limit", pagedListParameters.getLimit());
        }
        if (pagedListParameters.getSince() != null) {
            url = url + "&since={since}";
            params.put("since", pagedListParameters.getSince());
        }
        if (pagedListParameters.getUntil() != null) {
            url = url + "&until={until}";
            params.put("until", pagedListParameters.getUntil());
        }
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(url, JsonNode.class, params);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> searchHomeFeed(String query) {
        return this.searchHomeFeed(query, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> searchHomeFeed(String query, int offset, int limit) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)"https://graph.facebook.com/me/home").queryParam("q", query).queryParam("offset", String.valueOf(offset)).queryParam("limit", String.valueOf(limit)).build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> searchHomeFeed(String query, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        URIBuilder uriBuilder = URIBuilder.fromUri((String)"https://graph.facebook.com/me/home").queryParam("q", query);
        uriBuilder = this.appendPagedListParameters(pagedListParameters, uriBuilder);
        URI uri = uriBuilder.build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> searchUserFeed(String query) {
        return this.searchUserFeed("me", query, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> searchUserFeed(String query, int offset, int limit) {
        return this.searchUserFeed("me", query, offset, limit);
    }

    @Override
    public PagedList<Post> searchUserFeed(String query, PagingParameters pagedListParameters) {
        return this.searchUserFeed("me", query, pagedListParameters);
    }

    @Override
    public PagedList<Post> searchUserFeed(String userId, String query) {
        return this.searchUserFeed(userId, query, FIRST_PAGE);
    }

    @Override
    public PagedList<Post> searchUserFeed(String userId, String query, int offset, int limit) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/" + userId + "/feed")).queryParam("q", query).queryParam("offset", String.valueOf(offset)).queryParam("limit", String.valueOf(limit)).build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return this.deserializeList(responseNode, null, Post.class);
    }

    @Override
    public PagedList<Post> searchUserFeed(String userId, String query, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        URIBuilder uriBuilder = URIBuilder.fromUri((String)("https://graph.facebook.com/" + userId + "/feed")).queryParam("q", query);
        uriBuilder = this.appendPagedListParameters(pagedListParameters, uriBuilder);
        URI uri = uriBuilder.build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return this.deserializeList(responseNode, null, Post.class);
    }

    private JsonNode fetchConnectionList(String baseUri, int offset, int limit) {
        URI uri = URIBuilder.fromUri((String)baseUri).queryParam("offset", String.valueOf(offset)).queryParam("limit", String.valueOf(limit)).build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return responseNode;
    }

    private JsonNode fetchConnectionList(String baseUri, PagingParameters pagedListParameters) {
        URIBuilder uriBuilder = URIBuilder.fromUri((String)baseUri);
        uriBuilder = this.appendPagedListParameters(pagedListParameters, uriBuilder);
        URI uri = uriBuilder.build();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject(uri, JsonNode.class);
        return responseNode;
    }

    private <T> PagedList<T> deserializeList(JsonNode jsonNode, String postType, Class<T> type) {
        JsonNode dataNode = jsonNode.get("data");
        ArrayList<T> posts = new ArrayList<T>();
        Iterator iterator = dataNode.iterator();
        while (iterator.hasNext()) {
            posts.add(this.deserializePost(postType, type, (ObjectNode)iterator.next()));
        }
        if (jsonNode.has("paging")) {
            JsonNode pagingNode = jsonNode.get("paging");
            PagingParameters previousPage = PagedListUtils.getPagedListParameters(pagingNode, "previous");
            PagingParameters nextPage = PagedListUtils.getPagedListParameters(pagingNode, "next");
            return new PagedList(posts, previousPage, nextPage);
        }
        return new PagedList(posts, null, null);
    }

    private <T> T deserializePost(String postType, Class<T> type, ObjectNode node) {
        try {
            if (postType == null) {
                postType = this.determinePostType(node);
            }
            node.put("postType", postType);
            node.put("type", postType);
            return (T)this.objectMapper.readValue((JsonNode)node, type);
        }
        catch (IOException shouldntHappen) {
            throw new UncategorizedApiException("Error deserializing " + postType + " post", (Throwable)shouldntHappen);
        }
    }

    private String determinePostType(ObjectNode node) {
        if (node.has("type")) {
            try {
                String type = node.get("type").getTextValue();
                Post.PostType.valueOf(type.toUpperCase());
                return type;
            }
            catch (IllegalArgumentException e) {
                return "post";
            }
        }
        return "post";
    }

    private URIBuilder appendPagedListParameters(PagingParameters pagedListParameters, URIBuilder uriBuilder) {
        if (pagedListParameters.getLimit() != null) {
            uriBuilder = uriBuilder.queryParam("limit", String.valueOf(pagedListParameters.getLimit()));
        }
        if (pagedListParameters.getSince() != null) {
            uriBuilder = uriBuilder.queryParam("since", String.valueOf(pagedListParameters.getSince()));
        }
        if (pagedListParameters.getUntil() != null) {
            uriBuilder = uriBuilder.queryParam("until", String.valueOf(pagedListParameters.getUntil()));
        }
        return uriBuilder;
    }
}

