/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.social.facebook.api.FqlOperations;
import org.springframework.social.facebook.api.FqlResult;
import org.springframework.social.facebook.api.FqlResultMapper;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FqlTemplate
extends AbstractFacebookOperations
implements FqlOperations {
    private final GraphApi graphApi;

    public FqlTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public <T> List<T> query(String fql, FqlResultMapper<T> mapper) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"q", (Object)fql);
        Map resultSet = this.graphApi.fetchObject("fql", Map.class, (MultiValueMap<String, String>)parameters);
        List resultSetData = (List)resultSet.get("data");
        ArrayList<T> response = new ArrayList<T>();
        for (Map dataItem : resultSetData) {
            response.add(mapper.mapObject(new FqlResult(dataItem)));
        }
        return response;
    }
}

