/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.MissingNamespaceException;
import org.springframework.social.facebook.api.OpenGraphOperations;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class OpenGraphTemplate
extends AbstractFacebookOperations
implements OpenGraphOperations {
    private GraphApi graphApi;

    public OpenGraphTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    public String publishAction(String action, String objectType, String objectUrl) {
        this.requireAuthorization();
        this.requireApplicationNamespace();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)objectType, (Object)objectUrl);
        return this.graphApi.publish("me", this.graphApi.getApplicationNamespace() + ":" + action, (MultiValueMap<String, Object>)parameters);
    }

    private void requireApplicationNamespace() {
        String applicationNamespace = this.graphApi.getApplicationNamespace();
        if (applicationNamespace == null || applicationNamespace.isEmpty()) {
            throw new MissingNamespaceException();
        }
    }
}

