/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.codehaus.jackson.JsonNode;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PagedListUtils {
    PagedListUtils() {
    }

    public static PagingParameters getPagedListParameters(JsonNode pagingNode, String pageKey) {
        if (pagingNode == null || pagingNode.get(pageKey) == null) {
            return null;
        }
        String pageNode = pagingNode.get(pageKey).getTextValue();
        String limitString = PagedListUtils.extractParameterValueFromUrl(pageNode, "limit");
        String sinceString = PagedListUtils.extractParameterValueFromUrl(pageNode, "since");
        String untilString = PagedListUtils.extractParameterValueFromUrl(pageNode, "until");
        String offsetString = PagedListUtils.extractParameterValueFromUrl(pageNode, "offset");
        return new PagingParameters(offsetString != null ? Integer.valueOf(offsetString) : null, limitString != null ? Integer.valueOf(limitString) : null, sinceString != null ? Long.valueOf(sinceString) : null, untilString != null ? Long.valueOf(untilString) : null);
    }

    public static MultiValueMap<String, String> getPagingParameters(PagingParameters pagedListParameters) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (pagedListParameters.getOffset() != null) {
            parameters.add((Object)"offset", (Object)String.valueOf(pagedListParameters.getOffset()));
        }
        if (pagedListParameters.getLimit() != null) {
            parameters.add((Object)"limit", (Object)String.valueOf(pagedListParameters.getLimit()));
        }
        if (pagedListParameters.getSince() != null) {
            parameters.add((Object)"since", (Object)String.valueOf(pagedListParameters.getSince()));
        }
        if (pagedListParameters.getUntil() != null) {
            parameters.add((Object)"until", (Object)String.valueOf(pagedListParameters.getUntil()));
        }
        return parameters;
    }

    private static String extractParameterValueFromUrl(String url, String paramName) {
        int queryStart = url.indexOf(63) >= 0 ? url.indexOf(63) : 0;
        int startPos = url.indexOf(paramName + "=", queryStart);
        if (startPos == -1) {
            return null;
        }
        int ampPos = url.indexOf("&", startPos);
        if (ampPos >= 0) {
            return url.substring(startPos + paramName.length() + 1, ampPos);
        }
        return url.substring(startPos + paramName.length() + 1);
    }
}

