/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.springframework.social.facebook.api.FacebookProfile;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.UserOperations;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserTemplate
extends AbstractFacebookOperations
implements UserOperations {
    private final GraphApi graphApi;
    private final RestTemplate restTemplate;

    public UserTemplate(GraphApi graphApi, RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
    }

    @Override
    public FacebookProfile getUserProfile() {
        this.requireAuthorization();
        return this.getUserProfile("me");
    }

    @Override
    public FacebookProfile getUserProfile(String facebookId) {
        return this.graphApi.fetchObject(facebookId, FacebookProfile.class);
    }

    @Override
    public byte[] getUserProfileImage() {
        this.requireAuthorization();
        return this.getUserProfileImage("me", ImageType.NORMAL);
    }

    @Override
    public byte[] getUserProfileImage(String userId) {
        return this.getUserProfileImage(userId, ImageType.NORMAL);
    }

    @Override
    public byte[] getUserProfileImage(ImageType imageType) {
        this.requireAuthorization();
        return this.getUserProfileImage("me", imageType);
    }

    @Override
    public byte[] getUserProfileImage(String userId, ImageType imageType) {
        return this.graphApi.fetchImage(userId, "picture", imageType);
    }

    @Override
    public PagedList<String> getUserPermissions() {
        this.requireAuthorization();
        JsonNode responseNode = (JsonNode)this.restTemplate.getForObject("https://graph.facebook.com/me/permissions", JsonNode.class, new Object[0]);
        return this.deserializePermissionsNodeToList(responseNode);
    }

    @Override
    public PagedList<Reference> search(String query) {
        this.requireAuthorization();
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"user");
        return this.graphApi.fetchConnections("search", null, Reference.class, (MultiValueMap<String, String>)queryMap);
    }

    private PagedList<String> deserializePermissionsNodeToList(JsonNode jsonNode) {
        JsonNode dataNode = jsonNode.get("data");
        ArrayList permissions = new ArrayList();
        Iterator elementIt = dataNode.getElements();
        while (elementIt.hasNext()) {
            JsonNode permissionsElement = (JsonNode)elementIt.next();
            Iterator fieldNamesIt = permissionsElement.getFieldNames();
            while (fieldNamesIt.hasNext()) {
                permissions.add(fieldNamesIt.next());
            }
        }
        JsonNode pagingNode = jsonNode.get("paging");
        if (pagingNode != null) {
            PagingParameters previousPage = PagedListUtils.getPagedListParameters(pagingNode, "previous");
            PagingParameters nextPage = PagedListUtils.getPagedListParameters(pagingNode, "next");
            return new PagedList<String>(permissions, previousPage, nextPage);
        }
        return new PagedList<String>(permissions, null, null);
    }
}

