/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.facebook.api.Comment;
import org.springframework.social.facebook.api.ListAndCount;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommentListAndCountDeserializer
extends JsonDeserializer<ListAndCount<Comment>> {
    CommentListAndCountDeserializer() {
    }

    public ListAndCount<Comment> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDeserializationConfig(ctxt.getConfig());
        jp.setCodec((ObjectCodec)mapper);
        if (jp.hasCurrentToken()) {
            JsonNode commentsNode = jp.readValueAsTree();
            JsonNode dataNode = commentsNode.get("data");
            List commentsList = dataNode != null ? (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<Comment>>(){}) : Collections.emptyList();
            JsonNode countNode = commentsNode.get("count");
            int commentCount = countNode != null ? countNode.getIntValue() : 0;
            return new ListAndCount<Comment>(commentsList, commentCount);
        }
        return null;
    }
}

