/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.facebook.api.ListAndCount;
import org.springframework.social.facebook.api.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceListAndCountDeserializer
extends JsonDeserializer<ListAndCount<Reference>> {
    ReferenceListAndCountDeserializer() {
    }

    public ListAndCount<Reference> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDeserializationConfig(ctxt.getConfig());
        jp.setCodec((ObjectCodec)mapper);
        if (jp.hasCurrentToken()) {
            JsonNode node = jp.readValueAsTree();
            JsonNode dataNode = node.get("data");
            List commentsList = dataNode != null ? (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<Reference>>(){}) : Collections.emptyList();
            JsonNode countNode = node.get("count");
            int referenceCount = countNode != null ? countNode.getIntValue() : 0;
            return new ListAndCount<Reference>(commentsList, referenceCount);
        }
        return null;
    }
}

