/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.config.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.annotation.AbstractProviderConfigRegistrarSupport;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.social.facebook.config.annotation.EnableFacebook;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.social.facebook.security.FacebookAuthenticationService;
import org.springframework.social.security.provider.SocialAuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookProviderConfigRegistrar
extends AbstractProviderConfigRegistrarSupport {
    public FacebookProviderConfigRegistrar() {
        super(EnableFacebook.class, FacebookConnectionFactory.class, FacebookApiHelper.class);
    }

    protected Class<? extends SocialAuthenticationService<?>> getAuthenticationServiceClass() {
        return FacebookAuthenticationService.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FacebookApiHelper
    implements ApiHelper<Facebook> {
        private final UsersConnectionRepository usersConnectionRepository;
        private final UserIdSource userIdSource;
        private static final Log logger = LogFactory.getLog(FacebookApiHelper.class);

        private FacebookApiHelper(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
            this.usersConnectionRepository = usersConnectionRepository;
            this.userIdSource = userIdSource;
        }

        public Facebook getApi() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Getting API binding instance for Facebook provider");
            }
            Connection connection = this.usersConnectionRepository.createConnectionRepository(this.userIdSource.getUserId()).findPrimaryConnection(Facebook.class);
            if (logger.isDebugEnabled() && connection == null) {
                logger.debug((Object)"No current connection; Returning default FacebookTemplate instance.");
            }
            return connection != null ? (Facebook)connection.getApi() : new FacebookTemplate();
        }
    }
}

