/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.config.xml;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.xml.AbstractProviderConfigBeanDefinitionParser;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.social.facebook.security.FacebookAuthenticationService;
import org.springframework.social.security.provider.SocialAuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacebookConfigBeanDefinitionParser
extends AbstractProviderConfigBeanDefinitionParser {
    public FacebookConfigBeanDefinitionParser() {
        super(FacebookConnectionFactory.class, FacebookApiHelper.class);
    }

    protected Class<? extends SocialAuthenticationService<?>> getAuthenticationServiceClass() {
        return FacebookAuthenticationService.class;
    }

    protected BeanDefinition getConnectionFactoryBeanDefinition(String appId, String appSecret, Map<String, Object> allAttributes) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FacebookConnectionFactory.class).addConstructorArgValue((Object)appId).addConstructorArgValue((Object)appSecret);
        if (allAttributes.containsKey("app-namespace")) {
            builder.addConstructorArgValue(allAttributes.get("app-namespace"));
        }
        return builder.getBeanDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FacebookApiHelper
    implements ApiHelper<Facebook> {
        private final UsersConnectionRepository usersConnectionRepository;
        private final UserIdSource userIdSource;
        private static final Log logger = LogFactory.getLog(FacebookApiHelper.class);

        private FacebookApiHelper(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
            this.usersConnectionRepository = usersConnectionRepository;
            this.userIdSource = userIdSource;
        }

        public Facebook getApi() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Getting API binding instance for Facebook");
            }
            Connection connection = this.usersConnectionRepository.createConnectionRepository(this.userIdSource.getUserId()).findPrimaryConnection(Facebook.class);
            if (logger.isDebugEnabled() && connection == null) {
                logger.debug((Object)"No current connection; Returning default FacebookTemplate instance.");
            }
            return connection != null ? (Facebook)connection.getApi() : new FacebookTemplate();
        }
    }
}

