/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.social.facebook.api.Album;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.MediaOperations;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.Photo;
import org.springframework.social.facebook.api.Video;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MediaTemplate
extends AbstractFacebookOperations
implements MediaOperations {
    private final GraphApi graphApi;
    private final RestTemplate restTemplate;

    public MediaTemplate(GraphApi graphApi, RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
    }

    @Override
    public PagedList<Album> getAlbums() {
        this.requireAuthorization();
        return this.getAlbums("me", 0, 25);
    }

    @Override
    public PagedList<Album> getAlbums(int offset, int limit) {
        this.requireAuthorization();
        return this.getAlbums("me", offset, limit);
    }

    @Override
    public PagedList<Album> getAlbums(PagingParameters pagedListParameters) {
        this.requireAuthorization();
        return this.getAlbums("me", pagedListParameters);
    }

    @Override
    public PagedList<Album> getAlbums(String userId) {
        return this.getAlbums(userId, 0, 25);
    }

    @Override
    public PagedList<Album> getAlbums(String userId, int offset, int limit) {
        return this.getAlbums(userId, new PagingParameters(limit, offset, null, null));
    }

    @Override
    public PagedList<Album> getAlbums(String userId, PagingParameters pagedListParameters) {
        return this.graphApi.fetchConnections(userId, "albums", Album.class, PagedListUtils.getPagingParameters(pagedListParameters));
    }

    @Override
    public Album getAlbum(String albumId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(albumId, Album.class);
    }

    @Override
    public String createAlbum(String name, String description) {
        this.requireAuthorization();
        return this.createAlbum("me", name, description);
    }

    public String createAlbum(String ownerId, String name, String description) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"name", (Object)name);
        data.set((Object)"message", (Object)description);
        return this.graphApi.publish(ownerId, "albums", (MultiValueMap<String, Object>)data);
    }

    @Override
    public byte[] getAlbumImage(String albumId) {
        return this.getAlbumImage(albumId, ImageType.NORMAL);
    }

    @Override
    public byte[] getAlbumImage(String albumId, ImageType imageType) {
        this.requireAuthorization();
        return this.graphApi.fetchImage(albumId, "picture", imageType);
    }

    @Override
    public PagedList<Photo> getPhotos(String objectId) {
        return this.getPhotos(objectId, 0, 25);
    }

    @Override
    public PagedList<Photo> getPhotos(String objectId, int offset, int limit) {
        return this.getPhotos(objectId, new PagingParameters(limit, offset, null, null));
    }

    @Override
    public PagedList<Photo> getPhotos(String objectId, PagingParameters pagedListParameters) {
        return this.graphApi.fetchConnections(objectId, "photos", Photo.class, PagedListUtils.getPagingParameters(pagedListParameters));
    }

    @Override
    public Photo getPhoto(String photoId) {
        return this.graphApi.fetchObject(photoId, Photo.class);
    }

    @Override
    public byte[] getPhotoImage(String photoId) {
        return this.getPhotoImage(photoId, ImageType.NORMAL);
    }

    @Override
    public byte[] getPhotoImage(String photoId, ImageType imageType) {
        return this.graphApi.fetchImage(photoId, "picture", imageType);
    }

    @Override
    public String postPhoto(Resource photo) {
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"source", (Object)photo);
        return this.graphApi.publish("me", "photos", (MultiValueMap<String, Object>)parts);
    }

    @Override
    public String postPhoto(Resource photo, String caption) {
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"source", (Object)photo);
        parts.set((Object)"message", (Object)caption);
        return this.graphApi.publish("me", "photos", (MultiValueMap<String, Object>)parts);
    }

    @Override
    public String postPhoto(String albumId, Resource photo) {
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"source", (Object)photo);
        return this.graphApi.publish(albumId, "photos", (MultiValueMap<String, Object>)parts);
    }

    @Override
    public String postPhoto(String albumId, Resource photo, String caption) {
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"source", (Object)photo);
        parts.set((Object)"message", (Object)caption);
        return this.graphApi.publish(albumId, "photos", (MultiValueMap<String, Object>)parts);
    }

    @Override
    public PagedList<Video> getVideos() {
        return this.getVideos("me", 0, 25);
    }

    @Override
    public PagedList<Video> getVideos(int offset, int limit) {
        return this.getVideos("me", new PagingParameters(limit, offset, null, null));
    }

    @Override
    public PagedList<Video> getVideos(PagingParameters pagedListParameters) {
        return this.getVideos("me", pagedListParameters);
    }

    @Override
    public PagedList<Video> getVideos(String userId) {
        return this.getVideos(userId, 0, 25);
    }

    @Override
    public PagedList<Video> getVideos(String userId, int offset, int limit) {
        return this.getVideos(userId, new PagingParameters(limit, offset, null, null));
    }

    @Override
    public PagedList<Video> getVideos(String userId, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "videos", Video.class, PagedListUtils.getPagingParameters(pagedListParameters));
    }

    @Override
    public Video getVideo(String videoId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(videoId, Video.class);
    }

    @Override
    public byte[] getVideoImage(String videoId) {
        return this.getVideoImage(videoId, ImageType.NORMAL);
    }

    @Override
    public byte[] getVideoImage(String videoId, ImageType imageType) {
        this.requireAuthorization();
        return this.graphApi.fetchImage(videoId, "picture", imageType);
    }

    @Override
    public String postVideo(Resource video) {
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"file", (Object)video);
        Map response = (Map)this.restTemplate.postForObject("https://graph-video.facebook.com/me/videos", (Object)parts, Map.class, new Object[0]);
        return (String)response.get("id");
    }

    @Override
    public String postVideo(Resource video, String title, String description) {
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"file", (Object)video);
        parts.set((Object)"title", (Object)title);
        parts.set((Object)"description", (Object)description);
        Map response = (Map)this.restTemplate.postForObject("https://graph-video.facebook.com/me/videos", (Object)parts, Map.class, new Object[0]);
        return (String)response.get("id");
    }
}

