/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.Question;
import org.springframework.social.facebook.api.QuestionOperations;
import org.springframework.social.facebook.api.QuestionOption;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QuestionTemplate
extends AbstractFacebookOperations
implements QuestionOperations {
    private GraphApi graphApi;

    public QuestionTemplate(GraphApi graphApi, boolean isAuthorized) {
        super(isAuthorized);
        this.graphApi = graphApi;
    }

    @Override
    public String askQuestion(String questionText) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"question", (Object)questionText);
        return this.graphApi.publish("me", "questions", (MultiValueMap<String, Object>)data);
    }

    @Override
    public String addOption(String questionId, String optionText) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"option", (Object)optionText);
        return this.graphApi.publish(questionId, "options", (MultiValueMap<String, Object>)data);
    }

    @Override
    public PagedList<Question> getQuestions() {
        return this.getQuestions("me");
    }

    @Override
    public PagedList<Question> getQuestions(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "questions", Question.class, new String[0]);
    }

    @Override
    public void deleteQuestion(String questionId) {
        this.requireAuthorization();
        this.graphApi.delete(questionId);
    }

    @Override
    public Question getQuestion(String questionId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(questionId, Question.class);
    }

    @Override
    public QuestionOption getOption(String optionId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(optionId, QuestionOption.class);
    }

    @Override
    public PagedList<QuestionOption> getOptions(String questionId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(questionId, "options", QuestionOption.class, new String[0]);
    }

    @Override
    public void deleteOption(String optionId) {
        this.requireAuthorization();
        this.graphApi.delete(optionId);
    }
}

