/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.social.facebook.api.CheckinPost;
import org.springframework.social.facebook.api.Comment;
import org.springframework.social.facebook.api.LinkPost;
import org.springframework.social.facebook.api.ListAndCount;
import org.springframework.social.facebook.api.MusicPost;
import org.springframework.social.facebook.api.NotePost;
import org.springframework.social.facebook.api.PhotoPost;
import org.springframework.social.facebook.api.Post;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.StatusPost;
import org.springframework.social.facebook.api.StoryTag;
import org.springframework.social.facebook.api.SwfPost;
import org.springframework.social.facebook.api.VideoPost;
import org.springframework.social.facebook.api.impl.json.CommentListAndCountDeserializer;
import org.springframework.social.facebook.api.impl.json.PictureDeserializer;
import org.springframework.social.facebook.api.impl.json.ReferenceListAndCountDeserializer;
import org.springframework.social.facebook.api.impl.json.ReferenceListDeserializer;
import org.springframework.social.facebook.api.impl.json.StoryTagMapDeserializer;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="postType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(name="checkin", value=CheckinPost.class), @JsonSubTypes.Type(name="link", value=LinkPost.class), @JsonSubTypes.Type(name="note", value=NotePost.class), @JsonSubTypes.Type(name="photo", value=PhotoPost.class), @JsonSubTypes.Type(name="status", value=StatusPost.class), @JsonSubTypes.Type(name="video", value=VideoPost.class), @JsonSubTypes.Type(name="post", value=Post.class), @JsonSubTypes.Type(name="swf", value=SwfPost.class), @JsonSubTypes.Type(name="music", value=MusicPost.class)})
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PostMixin {
    @JsonProperty(value="to")
    @JsonDeserialize(using=ReferenceListDeserializer.class)
    List<Reference> to;
    @JsonProperty(value="message")
    String message;
    @JsonProperty(value="caption")
    String caption;
    @JsonProperty(value="picture")
    @JsonDeserialize(using=PictureDeserializer.class)
    String picture;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="subject")
    String subject;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="icon")
    String icon;
    @JsonProperty(value="application")
    Reference application;
    @JsonProperty(value="type")
    @JsonDeserialize(using=TypeDeserializer.class)
    Post.PostType type;
    @JsonProperty(value="shares")
    @JsonDeserialize(using=CountDeserializer.class)
    int sharesCount;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=ReferenceListAndCountDeserializer.class)
    ListAndCount<Reference> likes;
    @JsonProperty(value="comments")
    @JsonDeserialize(using=CommentListAndCountDeserializer.class)
    ListAndCount<Comment> comments;
    @JsonProperty(value="story")
    String story;
    @JsonProperty(value="story_tags")
    @JsonDeserialize(using=StoryTagMapDeserializer.class)
    Map<Integer, List<StoryTag>> storyTags;

    @JsonCreator
    PostMixin(@JsonProperty(value="id") String id, @JsonProperty(value="from") Reference from, @JsonProperty(value="created_time") Date createdTime, @JsonProperty(value="updated_time") Date updatedTime) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountDeserializer
    extends JsonDeserializer<Integer> {
        private CountDeserializer() {
        }

        public Integer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map map = (Map)jp.readValueAs(Map.class);
            return map.containsKey("count") ? Integer.valueOf(String.valueOf(map.get("count"))) : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDeserializer
    extends JsonDeserializer<Post.PostType> {
        private TypeDeserializer() {
        }

        public Post.PostType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Post.PostType.valueOf(jp.getText().toUpperCase());
        }
    }
}

