/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.ActionMetadata;
import org.springframework.social.facebook.api.MusicActions;
import org.springframework.social.facebook.api.OpenGraphOperations;
import org.springframework.util.MultiValueMap;

public class MusicActionsTemplate
implements MusicActions {
    private OpenGraphOperations openGraphOperations;

    public MusicActionsTemplate(OpenGraphOperations openGraphOperations) {
        this.openGraphOperations = openGraphOperations;
    }

    public String listenToSong(String songUrl) {
        return this.listen("song", songUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String listenToSong(String songUrl, ActionMetadata metadata) {
        return this.listen("song", songUrl, metadata);
    }

    public String listenToAlbum(String albumUrl) {
        return this.listen("album", albumUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String listenToAlbum(String albumUrl, ActionMetadata metadata) {
        return this.listen("album", albumUrl, metadata);
    }

    public String listenToMusician(String musicianUrl) {
        return this.listen("musician", musicianUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String listenToMusician(String musicianUrl, ActionMetadata metadata) {
        return this.listen("musician", musicianUrl, metadata);
    }

    public String listenToRadioStation(String radioStationUrl) {
        return this.listen("radio_station", radioStationUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String listenToRadioStation(String radioStationUrl, ActionMetadata metadata) {
        return this.listen("radio_station", radioStationUrl, metadata);
    }

    public String listenToPlaylist(String playlistUrl) {
        return this.listen("playlist", playlistUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String listenToPlaylist(String playlistUrl, ActionMetadata metadata) {
        return this.listen("playlist", playlistUrl, metadata);
    }

    public String listen(String objectType, String url, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)objectType, (Object)url);
        return this.openGraphOperations.publishAction("music.listens", parameters, true);
    }

    public String createPlaylist(String playlistUrl) {
        return this.createPlaylist(playlistUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String createPlaylist(String playlistUrl, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)"playlist", (Object)playlistUrl);
        return this.openGraphOperations.publishAction("music.playlists", parameters, true);
    }
}

