/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.ActionMetadata;
import org.springframework.social.facebook.api.BookActions;
import org.springframework.social.facebook.api.OpenGraphOperations;
import org.springframework.util.MultiValueMap;

public class BookActionsTemplate
implements BookActions {
    private OpenGraphOperations openGraphOperations;

    public BookActionsTemplate(OpenGraphOperations openGraphOperations) {
        this.openGraphOperations = openGraphOperations;
    }

    public String readBook(String bookUrl, long timestamp, float percentComplete) {
        return this.readBook(bookUrl, timestamp, percentComplete, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String readBook(String bookUrl, long timestamp, float percentComplete, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)"book", (Object)bookUrl);
        parameters.set((Object)"progress:timestamp", (Object)String.valueOf(timestamp));
        parameters.set((Object)"progress:percent_complete", (Object)String.valueOf(percentComplete));
        return this.openGraphOperations.publishAction("book.reads", parameters, true);
    }

    public String quoteBook(String bookUrl, String quote) {
        return this.quoteBook(bookUrl, quote, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String quoteBook(String bookUrl, String quote, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)"book", (Object)bookUrl);
        parameters.set((Object)"body", (Object)quote);
        return this.openGraphOperations.publishAction("books.quotes", parameters, true);
    }

    public String wantsToRead(String bookUrl) {
        return this.wantsToRead(bookUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String wantsToRead(String bookUrl, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)"book", (Object)bookUrl);
        return this.openGraphOperations.publishAction("books.wants_to_read", parameters, true);
    }

    public String rateBook(String bookUrl, float rating, int scale) {
        return this.rateBook(bookUrl, rating, scale, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    public String rateBook(String bookUrl, float rating, int scale, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)"book", (Object)bookUrl);
        parameters.set((Object)"rating:value", (Object)String.valueOf(rating));
        parameters.set((Object)"rating:scale", (Object)String.valueOf(scale));
        return this.openGraphOperations.publishAction("books.rates", parameters, true);
    }
}

