/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.social.facebook.api.Action;
import org.springframework.social.facebook.api.MessageTag;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.Post;
import org.springframework.social.facebook.api.PostProperty;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;
import org.springframework.social.facebook.api.impl.json.MessageTagMapDeserializer;
import org.springframework.social.facebook.api.impl.json.ReferenceListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PostMixin
extends FacebookObjectMixin {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="actions")
    List<Action> actions;
    @JsonProperty(value="admin_creator")
    Post.AdminCreator adminCreator;
    @JsonProperty(value="application")
    Reference application;
    @JsonProperty(value="caption")
    String caption;
    @JsonProperty(value="created_time")
    Date createdTime;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="from")
    Reference from;
    @JsonProperty(value="icon")
    String icon;
    @JsonProperty(value="is_hidden")
    boolean isHidden;
    @JsonProperty(value="is_published")
    boolean isPublished;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="message")
    String message;
    @JsonProperty(value="message_tags")
    @JsonDeserialize(using=MessageTagMapDeserializer.class)
    Map<Integer, List<MessageTag>> messageTags;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="object_id")
    String objectId;
    @JsonProperty(value="picture")
    String picture;
    @JsonProperty(value="place")
    Page place;
    @JsonProperty(value="privacy")
    Post.Privacy privacy;
    @JsonProperty(value="properties")
    List<PostProperty> properties;
    @JsonProperty(value="source")
    String source;
    @JsonProperty(value="status_type")
    @JsonDeserialize(using=StatusTypeDeserializer.class)
    Post.StatusType statusType;
    @JsonProperty(value="story")
    String story;
    @JsonProperty(value="to")
    @JsonDeserialize(using=ReferenceListDeserializer.class)
    List<Reference> to;
    @JsonProperty(value="type")
    @JsonDeserialize(using=PostTypeDeserializer.class)
    Post.PostType type;
    @JsonProperty(value="updated_time")
    Date updatedTime;
    @JsonProperty(value="with_tags")
    @JsonDeserialize(using=ReferenceListDeserializer.class)
    List<Reference> withTags;
    @JsonProperty(value="shares")
    @JsonDeserialize(using=CountDeserializer.class)
    Integer sharesCount;

    PostMixin() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountDeserializer
    extends JsonDeserializer<Integer> {
        private CountDeserializer() {
        }

        public Integer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map map = (Map)jp.readValueAs(Map.class);
            return map.containsKey("count") ? Integer.valueOf(String.valueOf(map.get("count"))) : 0;
        }

        public Integer getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatusTypeDeserializer
    extends JsonDeserializer<Post.StatusType> {
        private StatusTypeDeserializer() {
        }

        public Post.StatusType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Post.StatusType.valueOf(jp.getText().toUpperCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FriendsPrivacyTypeDeserializer
    extends JsonDeserializer<Post.FriendsPrivacyType> {
        private FriendsPrivacyTypeDeserializer() {
        }

        public Post.FriendsPrivacyType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return Post.FriendsPrivacyType.valueOf(jp.getText().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Post.FriendsPrivacyType.UNKNOWN;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivacyTypeDeserializer
    extends JsonDeserializer<Post.PrivacyType> {
        private PrivacyTypeDeserializer() {
        }

        public Post.PrivacyType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return Post.PrivacyType.valueOf(jp.getText().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Post.PrivacyType.UNKNOWN;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PostTypeDeserializer
    extends JsonDeserializer<Post.PostType> {
        private PostTypeDeserializer() {
        }

        public Post.PostType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return Post.PostType.valueOf(jp.getText().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Post.PostType.UNKNOWN;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static abstract class PrivacyMixin {
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="value")
        @JsonDeserialize(using=PrivacyTypeDeserializer.class)
        Post.PrivacyType value;
        @JsonProperty(value="friends")
        @JsonDeserialize(using=FriendsPrivacyTypeDeserializer.class)
        Post.FriendsPrivacyType friends;
        @JsonProperty(value="networks")
        String networks;
        @JsonProperty(value="allow")
        String allow;
        @JsonProperty(value="deny")
        String deny;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static abstract class AdminCreatorMixin {
        @JsonProperty(value="id")
        String id;
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="namespace")
        String namespace;
    }
}

