/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.springframework.social.facebook.api.AgeRange;
import org.springframework.social.facebook.api.CoverPhoto;
import org.springframework.social.facebook.api.EducationExperience;
import org.springframework.social.facebook.api.Experience;
import org.springframework.social.facebook.api.Location;
import org.springframework.social.facebook.api.PaymentPricePoints;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.VideoUploadLimits;
import org.springframework.social.facebook.api.WorkEntry;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class UserMixin
extends FacebookObjectMixin {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="about")
    String about;
    @JsonProperty(value="address")
    Location address;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="name_format")
    String nameFormat;
    @JsonProperty(value="first_name")
    String firstName;
    @JsonProperty(value="last_name")
    String lastName;
    @JsonProperty(value="cover")
    CoverPhoto cover;
    @JsonProperty(value="gender")
    String gender;
    @JsonProperty(value="installed")
    boolean installed;
    @JsonProperty(value="install_type")
    String installType;
    @JsonProperty(value="locale")
    Locale locale;
    @JsonProperty(value="middle_name")
    String middleName;
    @JsonProperty(value="work")
    List<WorkEntry> work;
    @JsonProperty(value="education")
    List<EducationExperience> education;
    @JsonProperty(value="email")
    String email;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="third_party_id")
    String thirdPartyId;
    @JsonProperty(value="timezone")
    Float timezone;
    @JsonProperty(value="updated_time")
    Date updatedTime;
    @JsonProperty(value="verified")
    Boolean verified;
    @JsonProperty(value="bio")
    String bio;
    @JsonProperty(value="birthday")
    String birthday;
    @JsonProperty(value="location")
    Reference location;
    @JsonProperty(value="hometown")
    Reference hometown;
    @JsonProperty(value="interested_in")
    List<String> interestedIn;
    @JsonProperty(value="inspirational_people")
    List<Reference> inspirationalPeople;
    @JsonProperty(value="is_verified")
    boolean isIdentityVerified;
    @JsonProperty(value="languages")
    List<Reference> languages;
    @JsonProperty(value="meeting_for")
    List<String> meetingFor;
    @JsonProperty(value="favorite_teams")
    List<Reference> favoriteTeams;
    @JsonProperty(value="favorite_athletes")
    List<Reference> favoriteAthletes;
    @JsonProperty(value="religion")
    String religion;
    @JsonProperty(value="payment_pricepoints")
    PaymentPricePoints paymentPricePoints;
    @JsonProperty(value="political")
    String political;
    @JsonProperty(value="quotes")
    String quotes;
    @JsonProperty(value="relationship_status")
    String relationshipStatus;
    @JsonProperty(value="significant_other")
    Reference significantOther;
    @JsonProperty(value="sports")
    List<Experience> sports;
    @JsonProperty(value="test_group")
    int testGroup;
    @JsonProperty(value="video_upload_limits")
    VideoUploadLimits videoUploadLimits;
    @JsonProperty(value="viewer_can_send_gift")
    boolean viewerCanSendGift;
    @JsonProperty(value="website")
    String website;
    @JsonProperty(value="age_range")
    @JsonDeserialize(using=AgeRangeDeserializer.class)
    AgeRange ageRange;

    UserMixin() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AgeRangeDeserializer
    extends JsonDeserializer<AgeRange> {
        private AgeRangeDeserializer() {
        }

        public AgeRange deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode ageRangeNode = (JsonNode)jp.readValueAs(JsonNode.class);
            JsonNode minNode = ageRangeNode.get("min");
            JsonNode maxNode = ageRangeNode.get("max");
            Integer min = minNode != null ? Integer.valueOf(minNode.asInt()) : null;
            Integer max = maxNode != null ? Integer.valueOf(maxNode.asInt()) : null;
            return AgeRange.fromMinMax(min, max);
        }
    }
}

