/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class ActionMetadata {
    private Date startTime;
    private Date endTime;
    private Date createdTime;
    private Integer expiresIn;
    private String place;
    private List<String> tags = new ArrayList<String>();
    private String message;
    private Boolean noFeedStory;
    private Boolean explicitlyShared;
    private String privacy;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public ActionMetadata startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public ActionMetadata endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public ActionMetadata createdTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public ActionMetadata expiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    public ActionMetadata place(String place) {
        this.place = place;
        return this;
    }

    public ActionMetadata tag(String user) {
        this.tags.add(user);
        return this;
    }

    public ActionMetadata message(String message) {
        this.message = message;
        return this;
    }

    public ActionMetadata noFeedStory(boolean noFeedStory) {
        this.noFeedStory = noFeedStory;
        return this;
    }

    public ActionMetadata explicitlyShared(boolean explicitlyShared) {
        this.explicitlyShared = explicitlyShared;
        return this;
    }

    public ActionMetadata privacy(String privacy) {
        this.privacy = privacy;
        return this;
    }

    public MultiValueMap<String, Object> toParameters() {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        this.setDateIfNotNull((MultiValueMap<String, Object>)params, "start_time", this.startTime);
        this.setDateIfNotNull((MultiValueMap<String, Object>)params, "end_time", this.endTime);
        this.setDateIfNotNull((MultiValueMap<String, Object>)params, "created_time", this.createdTime);
        if (this.expiresIn != null) {
            params.set((Object)"expires_in", (Object)String.valueOf(this.expiresIn));
        }
        this.setIfNotNull((MultiValueMap<String, Object>)params, "place", this.place);
        this.setTagsIfNotNull((MultiValueMap<String, Object>)params);
        this.setIfNotNull((MultiValueMap<String, Object>)params, "message", this.message);
        this.setIfBooleanNotNull((MultiValueMap<String, Object>)params, "no_feed_story", this.noFeedStory);
        this.setIfBooleanNotNull((MultiValueMap<String, Object>)params, "fb:explicitly_shared", this.explicitlyShared);
        if (this.privacy != null) {
            params.set((Object)"privacy", (Object)("{\"value\":\"" + this.privacy + "\"}"));
        }
        return params;
    }

    protected void setIfNotNull(MultiValueMap<String, Object> params, String key, Object value) {
        if (value != null) {
            params.set((Object)key, value);
        }
    }

    protected void setIfBooleanNotNull(MultiValueMap<String, Object> params, String key, Boolean value) {
        this.setIfNotNull(params, key, value != null ? value.toString() : null);
    }

    protected void setDateIfNotNull(MultiValueMap<String, Object> params, String key, Date value) {
        if (value != null) {
            String formattedDate = DATE_FORMAT.format(value);
            params.set((Object)key, (Object)formattedDate);
        }
    }

    private void setTagsIfNotNull(MultiValueMap<String, Object> params) {
        if (this.tags.size() > 0) {
            params.set((Object)"tags", (Object)StringUtils.collectionToCommaDelimitedString(this.tags));
        }
    }
}

