/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.BookActions;
import org.springframework.social.facebook.api.FitnessActions;
import org.springframework.social.facebook.api.GeneralActions;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.MissingNamespaceException;
import org.springframework.social.facebook.api.MusicActions;
import org.springframework.social.facebook.api.OpenGraphOperations;
import org.springframework.social.facebook.api.VideoActions;
import org.springframework.social.facebook.api.impl.BookActionsTemplate;
import org.springframework.social.facebook.api.impl.FitnessActionsTemplate;
import org.springframework.social.facebook.api.impl.GeneralActionsTemplate;
import org.springframework.social.facebook.api.impl.MusicActionsTemplate;
import org.springframework.social.facebook.api.impl.VideoActionsTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class OpenGraphTemplate
implements OpenGraphOperations {
    private GraphApi graphApi;
    private GeneralActions generalActions;
    private MusicActions musicActions;
    private BookActions bookActions;
    private VideoActions videoActions;
    private FitnessActions fitnessActions;

    public OpenGraphTemplate(GraphApi graphApi) {
        this.graphApi = graphApi;
        this.generalActions = new GeneralActionsTemplate(this);
        this.bookActions = new BookActionsTemplate(this);
        this.musicActions = new MusicActionsTemplate(this);
        this.videoActions = new VideoActionsTemplate(this);
        this.fitnessActions = new FitnessActionsTemplate(this);
    }

    @Override
    public GeneralActions generalActions() {
        return this.generalActions;
    }

    @Override
    public MusicActions musicActions() {
        return this.musicActions;
    }

    @Override
    public BookActions bookActions() {
        return this.bookActions;
    }

    @Override
    public VideoActions videoActions() {
        return this.videoActions;
    }

    @Override
    public FitnessActions fitnessActions() {
        return this.fitnessActions;
    }

    @Override
    public void deleteAction(String actionId) {
        this.graphApi.delete(actionId);
    }

    @Override
    public String publishAction(String action, String objectType, String objectUrl) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)objectType, (Object)objectUrl);
        return this.publishAction(this.graphApi.getApplicationNamespace() + ":" + action, (MultiValueMap<String, Object>)parameters, false);
    }

    @Override
    public String publishAction(String action, MultiValueMap<String, Object> parameters, boolean builtInAction) {
        if (!builtInAction) {
            this.requireApplicationNamespace();
        }
        return this.graphApi.publish("me", action, parameters);
    }

    private void requireApplicationNamespace() {
        String applicationNamespace = this.graphApi.getApplicationNamespace();
        if (applicationNamespace == null || applicationNamespace.isEmpty()) {
            throw new MissingNamespaceException();
        }
    }
}

