/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.social.facebook.api.Account;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.FacebookLink;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.PageAdministrationException;
import org.springframework.social.facebook.api.PageOperations;
import org.springframework.social.facebook.api.PagePostData;
import org.springframework.social.facebook.api.PageUpdate;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class PageTemplate
implements PageOperations {
    private final GraphApi graphApi;
    private Map<String, Account> accountCache = new HashMap<String, Account>();

    public PageTemplate(GraphApi graphApi) {
        this.graphApi = graphApi;
    }

    @Override
    public Page getPage(String pageId) {
        return this.graphApi.fetchObject(pageId, Page.class);
    }

    @Override
    public void updatePage(PageUpdate pageUpdate) {
        String pageId = pageUpdate.getPageId();
        String pageAccessToken = this.getAccessToken(pageId);
        MultiValueMap<String, Object> map = pageUpdate.toRequestParameters();
        map.add((Object)"access_token", (Object)pageAccessToken);
        this.graphApi.post(pageId, map);
    }

    @Override
    public boolean isPageAdmin(String pageId) {
        return this.getAccount(pageId) != null;
    }

    @Override
    public PagedList<Account> getAccounts() {
        return this.graphApi.fetchConnections("me", "accounts", Account.class, new String[0]);
    }

    @Override
    public String post(String pageId, String message) {
        return this.post(new PagePostData(pageId).message(message));
    }

    @Override
    public String post(String pageId, String message, FacebookLink link) {
        PagePostData postData = new PagePostData(pageId).message(message).link(link.getLink(), link.getPicture(), link.getName(), link.getCaption(), link.getDescription());
        return this.post(postData);
    }

    @Override
    public String post(PagePostData post) {
        String pageId = post.getPageId();
        String pageAccessToken = this.getAccessToken(pageId);
        MultiValueMap<String, Object> map = post.toRequestParameters();
        map.set((Object)"access_token", (Object)pageAccessToken);
        return this.graphApi.publish(pageId, "feed", map);
    }

    @Override
    public String postPhoto(String pageId, String albumId, Resource photo) {
        return this.postPhoto(pageId, albumId, photo, null);
    }

    @Override
    public String postPhoto(String pageId, String albumId, Resource photo, String caption) {
        String pageAccessToken = this.getAccessToken(pageId);
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"source", (Object)photo);
        if (caption != null) {
            parts.set((Object)"message", (Object)caption);
        }
        parts.set((Object)"access_token", (Object)pageAccessToken);
        return this.graphApi.publish(albumId, "photos", (MultiValueMap<String, Object>)parts);
    }

    @Override
    public PagedList<Page> search(String query) {
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"page");
        return this.graphApi.fetchConnections("search", null, Page.class, (MultiValueMap<String, String>)queryMap);
    }

    @Override
    public PagedList<Page> searchPlaces(String query, double latitude, double longitude, long distance) {
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"place");
        queryMap.add((Object)"center", (Object)(latitude + "," + longitude));
        queryMap.add((Object)"distance", (Object)String.valueOf(distance));
        return this.graphApi.fetchConnections("search", null, Page.class, (MultiValueMap<String, String>)queryMap);
    }

    @Override
    public String getAccessToken(String pageId) {
        Account account = this.getAccount(pageId);
        if (account == null) {
            throw new PageAdministrationException(pageId);
        }
        return account.getAccessToken();
    }

    @Override
    public Account getAccount(String pageId) {
        if (!this.accountCache.containsKey(pageId)) {
            PagedList<Account> accounts = this.getAccounts();
            for (Account account : accounts) {
                this.accountCache.put(account.getId(), account);
            }
        }
        return this.accountCache.get(pageId);
    }

    @Override
    public Facebook facebookOperations(String pageId) {
        return new FacebookTemplate(this.getAccessToken(pageId));
    }
}

