/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.springframework.social.facebook.api.Album;
import org.springframework.social.facebook.api.Location;
import org.springframework.social.facebook.api.Photo;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.Tag;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;
import org.springframework.social.facebook.api.impl.json.TagListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PhotoMixin
extends FacebookObjectMixin {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="album")
    Album album;
    @JsonProperty(value="backdated_time")
    Date backdatedTime;
    @JsonProperty(value="backdated_time_granularity")
    @JsonDeserialize(using=TimeGranularityDeserializer.class)
    Photo.TimeGranularity backdatedTimeGranularity;
    @JsonProperty(value="created_time")
    Date createdTime;
    @JsonProperty(value="from")
    Reference from;
    @JsonProperty(value="height")
    int height;
    @JsonProperty(value="picture")
    String picture;
    @JsonProperty(value="source")
    String source;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="icon")
    String icon;
    @JsonProperty(value="images")
    List<Photo.Image> images;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="page_story_id")
    String pageStoryId;
    @JsonProperty(value="place")
    Location place;
    @JsonProperty(value="updated_time")
    Date updatedTime;
    @JsonProperty(value="tags")
    @JsonDeserialize(using=TagListDeserializer.class)
    List<Tag> tags;

    PhotoMixin() {
    }

    public static class TimeGranularityDeserializer
    extends JsonDeserializer<Photo.TimeGranularity> {
        public Photo.TimeGranularity deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Photo.TimeGranularity.valueOf(jp.getText().toUpperCase());
        }
    }

    public static abstract class ImageMixin {
        @JsonCreator
        public ImageMixin(@JsonProperty(value="source") String source, @JsonProperty(value="width") int width, @JsonProperty(value="height") int height) {
        }
    }
}

