/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.springframework.social.facebook.api.FacebookObject;
import org.springframework.social.facebook.api.ProfilePictureSource;
import org.springframework.social.facebook.api.impl.json.FacebookModule;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class UserTaggableFriendMixin
extends FacebookObject {
    @JsonCreator
    UserTaggableFriendMixin(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="middle_name") String middleName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="picture") @JsonDeserialize(using=PictureDeserializer.class) ProfilePictureSource picture) {
    }

    private static class PictureDeserializer
    extends JsonDeserializer<ProfilePictureSource> {
        private PictureDeserializer() {
        }

        public ProfilePictureSource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new FacebookModule());
            JsonNode dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("data");
            return (ProfilePictureSource)mapper.reader(ProfilePictureSource.class).readValue(dataNode);
        }
    }
}

