/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.api.impl;

import org.springframework.social.github.api.GistOperations;
import org.springframework.social.github.api.GitHub;
import org.springframework.social.github.api.RepoOperations;
import org.springframework.social.github.api.UserOperations;
import org.springframework.social.github.api.impl.GistTemplate;
import org.springframework.social.github.api.impl.RepoTemplate;
import org.springframework.social.github.api.impl.UserTemplate;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.web.client.RestOperations;

public class GitHubTemplate
extends AbstractOAuth2ApiBinding
implements GitHub {
    private GistOperations gistOperations;
    private RepoOperations repoOperations;
    private UserOperations userOperations;

    public GitHubTemplate() {
        this.initSubApis();
    }

    public GitHubTemplate(String accessToken) {
        super(accessToken);
        this.initSubApis();
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.BEARER;
    }

    public GistOperations gistOperations() {
        return this.gistOperations;
    }

    public RepoOperations repoOperations() {
        return this.repoOperations;
    }

    public UserOperations userOperations() {
        return this.userOperations;
    }

    public RestOperations restOperations() {
        return this.getRestTemplate();
    }

    private void initSubApis() {
        this.gistOperations = new GistTemplate(this.getRestTemplate(), this.isAuthorized());
        this.repoOperations = new RepoTemplate(this.getRestTemplate(), this.isAuthorized());
        this.userOperations = new UserTemplate(this.getRestTemplate(), this.isAuthorized());
    }
}

