/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.api.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.social.github.api.GitHubUser;
import org.springframework.social.github.api.GitHubUserProfile;
import org.springframework.social.github.api.UserOperations;
import org.springframework.social.github.api.impl.AbstractGitHubOperations;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTemplate
extends AbstractGitHubOperations
implements UserOperations {
    private final RestTemplate restTemplate;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z", Locale.ENGLISH);

    @Override
    public String getProfileId() {
        return this.getUserProfile().getUsername();
    }

    @Override
    public GitHubUserProfile getUserProfile() {
        Map user = (Map)this.restTemplate.getForObject(this.buildUri("user"), Map.class, new Object[0]);
        Long gitHubId = Long.valueOf(String.valueOf(user.get("id")));
        String username = String.valueOf(user.get("login"));
        String name = String.valueOf(user.get("name"));
        String location = user.get("location") != null ? String.valueOf(user.get("location")) : null;
        String company = user.get("company") != null ? String.valueOf(user.get("company")) : null;
        String blog = user.get("blog") != null ? String.valueOf(user.get("blog")) : null;
        String email = user.get("email") != null ? String.valueOf(user.get("email")) : null;
        Date createdDate = this.toDate(String.valueOf(user.get("created_at")), this.dateFormat);
        String gravatarId = (String)user.get("gravatar_id");
        String profileImageUrl = gravatarId != null ? "https://secure.gravatar.com/avatar/" + gravatarId : null;
        return new GitHubUserProfile(gitHubId, username, name, location, company, blog, email, profileImageUrl, createdDate);
    }

    @Override
    public String getProfileUrl() {
        return "https://github.com/" + this.getProfileId();
    }

    public UserTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<GitHubUser> getFollowers(String user) {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.buildUserUri("/followers"), GitHubUser[].class, new Object[]{user}));
    }

    @Override
    public List<GitHubUser> getFollowing(String user) {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.buildUserUri("/following"), GitHubUser[].class, new Object[]{user}));
    }

    private String buildUserUri(String path) {
        return this.buildUri("users/{user}" + path);
    }

    private Date toDate(String dateString, DateFormat dateFormat) {
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

