/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.connect;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;
import org.springframework.social.github.api.GitHub;
import org.springframework.social.github.api.GitHubUserProfile;
import org.springframework.web.client.HttpClientErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHubAdapter
implements ApiAdapter<GitHub> {
    public boolean test(GitHub github) {
        try {
            github.userOperations().getUserProfile();
            return true;
        }
        catch (HttpClientErrorException e) {
            return false;
        }
    }

    public void setConnectionValues(GitHub github, ConnectionValues values) {
        GitHubUserProfile profile = github.userOperations().getUserProfile();
        values.setProviderUserId(String.valueOf(profile.getId()));
        values.setDisplayName(profile.getUsername());
        values.setProfileUrl("https://github.com/" + profile.getId());
        values.setImageUrl(profile.getProfileImageUrl());
    }

    public UserProfile fetchUserProfile(GitHub github) {
        GitHubUserProfile profile = github.userOperations().getUserProfile();
        return new UserProfileBuilder().setName(profile.getName()).setEmail(profile.getEmail()).setUsername(profile.getUsername()).build();
    }

    public void updateStatus(GitHub github, String message) {
    }
}

