/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.connect;

import org.springframework.social.github.api.GitHub;
import org.springframework.social.github.api.impl.GitHubTemplate;
import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHubServiceProvider
extends AbstractOAuth2ServiceProvider<GitHub> {
    public GitHubServiceProvider(String clientId, String clientSecret) {
        super((OAuth2Operations)GitHubServiceProvider.createOAuth2Template(clientId, clientSecret));
    }

    private static OAuth2Template createOAuth2Template(String clientId, String clientSecret) {
        OAuth2Template oAuth2Template = new OAuth2Template(clientId, clientSecret, "https://github.com/login/oauth/authorize", "https://github.com/login/oauth/access_token");
        oAuth2Template.setUseParametersForClientAuthentication(true);
        return oAuth2Template;
    }

    public GitHub getApi(String accessToken) {
        return new GitHubTemplate(accessToken);
    }
}

