/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.google.api.Google;
import org.springframework.social.google.api.drive.DriveOperations;
import org.springframework.social.google.api.drive.impl.DriveTemplate;
import org.springframework.social.google.api.plus.PlusOperations;
import org.springframework.social.google.api.plus.impl.PlusTemplate;
import org.springframework.social.google.api.tasks.TaskOperations;
import org.springframework.social.google.api.tasks.impl.TaskTemplate;
import org.springframework.social.google.api.userinfo.UserInfoOperations;
import org.springframework.social.google.api.userinfo.impl.UserInfoTemplate;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleTemplate
extends AbstractOAuth2ApiBinding
implements Google {
    private String accessToken;
    private UserInfoOperations userOperations;
    private PlusOperations plusOperations;
    private TaskOperations taskOperations;
    private DriveOperations driveOperations;

    public GoogleTemplate() {
        this.initialize();
    }

    public GoogleTemplate(String accessToken) {
        super(accessToken);
        this.accessToken = accessToken;
        this.initialize();
    }

    private void initialize() {
        this.userOperations = new UserInfoTemplate(this.getRestTemplate(), this.isAuthorized());
        this.plusOperations = new PlusTemplate(this.getRestTemplate(), this.isAuthorized());
        this.taskOperations = new TaskTemplate(this.getRestTemplate(), this.isAuthorized());
        this.driveOperations = new DriveTemplate(this.getRestTemplate(), this.isAuthorized());
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonConverter.setObjectMapper(objectMapper);
        FormHttpMessageConverter formHttpMessageConverter = new FormHttpMessageConverter();
        formHttpMessageConverter.addPartConverter((HttpMessageConverter)jsonConverter);
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)jsonConverter);
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)formHttpMessageConverter);
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        return messageConverters;
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.BEARER;
    }

    @Override
    public UserInfoOperations userOperations() {
        return this.userOperations;
    }

    @Override
    public PlusOperations plusOperations() {
        return this.plusOperations;
    }

    @Override
    public TaskOperations taskOperations() {
        return this.taskOperations;
    }

    @Override
    public DriveOperations driveOperations() {
        return this.driveOperations;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }
}

