/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.connect;

import org.springframework.social.ApiException;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;
import org.springframework.social.google.api.Google;
import org.springframework.social.google.api.userinfo.GoogleUserInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleAdapter
implements ApiAdapter<Google> {
    public boolean test(Google google) {
        try {
            google.userOperations().getUserInfo();
            return true;
        }
        catch (ApiException e) {
            return false;
        }
    }

    public void setConnectionValues(Google google, ConnectionValues values) {
        GoogleUserInfo profile = google.userOperations().getUserInfo();
        values.setProviderUserId(profile.getId());
        values.setDisplayName(profile.getName());
        values.setProfileUrl(profile.getLink());
        values.setImageUrl(profile.getProfilePictureUrl());
    }

    public UserProfile fetchUserProfile(Google google) {
        GoogleUserInfo profile = google.userOperations().getUserInfo();
        return new UserProfileBuilder().setUsername(profile.getId()).setEmail(profile.getEmail()).setName(profile.getName()).setFirstName(profile.getFirstName()).setLastName(profile.getLastName()).build();
    }

    public void updateStatus(Google google, String message) {
        throw new UnsupportedOperationException();
    }
}

