/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.util.HashMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.Job;
import org.springframework.social.linkedin.api.JobBookmarks;
import org.springframework.social.linkedin.api.JobOperations;
import org.springframework.social.linkedin.api.JobSearchParameters;
import org.springframework.social.linkedin.api.Jobs;
import org.springframework.social.linkedin.api.impl.AbstractTemplate;
import org.springframework.web.client.RestOperations;

class JobTemplate
extends AbstractTemplate
implements JobOperations {
    private final RestOperations restOperations;
    private final ObjectMapper objectMapper;
    public static final String BASE_URL = "https://api.linkedin.com/v1/";
    public static final String FIELDS = "(id,customer-job-code,active,posting-date,expiration-date,posting-timestamp,expiration-timestamp,company:(id,name),position:(title,location,job-functions,industries,job-type,experience-level),skills-and-experience,description-snippet,description,salary,job-poster:(id,first-name,last-name,headline),referral-bonus,site-job-url,location-description)";
    public static final String SEARCH_FIELDS = "(jobs:(id,customer-job-code,active,posting-date,expiration-date,posting-timestamp,expiration-timestamp,company:(id,name),position:(title,location,job-functions,industries,job-type,experience-level),skills-and-experience,description-snippet,description,salary,job-poster:(id,first-name,last-name,headline),referral-bonus,site-job-url,location-description))";
    public static final String SEARCH_URL = "https://api.linkedin.com/v1/job-search:(jobs:(id,customer-job-code,active,posting-date,expiration-date,posting-timestamp,expiration-timestamp,company:(id,name),position:(title,location,job-functions,industries,job-type,experience-level),skills-and-experience,description-snippet,description,salary,job-poster:(id,first-name,last-name,headline),referral-bonus,site-job-url,location-description))?{&keywords}{&company-name}{&job-title}{&country-code}{&postal-code}{&distance}{&start}{&count}{&sort}";
    public static final String JOB_URL = "https://api.linkedin.com/v1/jobs/{id}:(id,customer-job-code,active,posting-date,expiration-date,posting-timestamp,expiration-timestamp,company:(id,name),position:(title,location,job-functions,industries,job-type,experience-level),skills-and-experience,description-snippet,description,salary,job-poster:(id,first-name,last-name,headline),referral-bonus,site-job-url,location-description)";
    public static final String BOOKMARK_URL = "https://api.linkedin.com/v1/people/~/job-bookmarks";
    public static final String BOOKMARKS_URL = "https://api.linkedin.com/v1/people/~/job-bookmarks?{&start}{&count}";
    public static final String UNBOOKMARK_URL = "https://api.linkedin.com/v1/people/~/job-bookmarks/{job-id}";
    public static final String SUGGESTED_URL = "https://api.linkedin.com/v1/people/~/suggestions/job-suggestions:(jobs:(id,customer-job-code,active,posting-date,expiration-date,posting-timestamp,expiration-timestamp,company:(id,name),position:(title,location,job-functions,industries,job-type,experience-level),skills-and-experience,description-snippet,description,salary,job-poster:(id,first-name,last-name,headline),referral-bonus,site-job-url,location-description))?{&start}{&count}";

    public JobTemplate(RestOperations restOperations, ObjectMapper objectMapper) {
        this.restOperations = restOperations;
        this.objectMapper = objectMapper;
    }

    public Jobs searchJobs(JobSearchParameters parameters) {
        Object[] params = new Object[]{parameters.getKeywords(), parameters.getCompanyName(), parameters.getJobTitle(), parameters.getCountryCode(), parameters.getPostalCode(), parameters.getDistance(), parameters.getStart(), parameters.getCount(), parameters.getSort()};
        JsonNode node = (JsonNode)this.restOperations.getForObject(this.expand(SEARCH_URL, params, true), JsonNode.class);
        try {
            return (Jobs)this.objectMapper.readValue(node.path("jobs"), (TypeReference)new TypeReference<Jobs>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Job getJob(int id) {
        return (Job)this.restOperations.getForObject(JOB_URL, Job.class, new Object[]{id});
    }

    public void bookmarkJob(int id) {
        HashMap jobDetails = new HashMap();
        HashMap<String, Integer> idDetails = new HashMap<String, Integer>();
        jobDetails.put("job", idDetails);
        idDetails.put("id", id);
        this.restOperations.postForLocation(BOOKMARK_URL, jobDetails, new Object[0]);
    }

    public void unbookmarkJob(int id) {
        this.restOperations.delete(UNBOOKMARK_URL, new Object[]{id});
    }

    public Jobs getSuggestions(int start, int count) {
        JsonNode node = (JsonNode)this.restOperations.getForObject(this.expand(SUGGESTED_URL, new Object[]{start, count}, false), JsonNode.class);
        try {
            return (Jobs)this.objectMapper.readValue(node.path("jobs"), (TypeReference)new TypeReference<Jobs>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JobBookmarks getBookmarks(int start, int count) {
        return (JobBookmarks)this.restOperations.getForObject(this.expand(BOOKMARKS_URL, new Object[]{start, count}, false), JobBookmarks.class);
    }
}

