/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.UpdateType;
import org.springframework.social.linkedin.api.impl.json.LikesListDeserializer;
import org.springframework.social.linkedin.api.impl.json.UpdateTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class LinkedInNetworkUpdateMixin {
    @JsonProperty(value="isCommentable")
    boolean commentable;
    @JsonProperty(value="isLikable")
    boolean likeable;
    @JsonProperty(value="isLiked")
    boolean liked;
    @JsonProperty(value="numLikes")
    int numLikes;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;
    @JsonProperty(value="updatedFields")
    @JsonDeserialize(using=UpdatedFieldsListDeserializer.class)
    List<String> updatedFields;

    @JsonCreator
    LinkedInNetworkUpdateMixin(@JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="updateKey") String updateKey, @JsonProperty(value="updateType") @JsonDeserialize(using=UpdateTypeDeserializer.class) UpdateType updateType) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdatedFieldsListDeserializer
    extends JsonDeserializer<List<String>> {
        private UpdatedFieldsListDeserializer() {
        }

        public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken()) {
                JsonNode dataNode = jp.readValueAsTree().get("values");
                ArrayList<String> values = new ArrayList<String>();
                for (JsonNode value : dataNode) {
                    values.add(value.get("name").getTextValue());
                }
                return values;
            }
            return null;
        }
    }
}

