/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.social.linkedin.api.ConnectionAuthorization;
import org.springframework.social.linkedin.api.CurrentShare;
import org.springframework.social.linkedin.api.Education;
import org.springframework.social.linkedin.api.ImAccount;
import org.springframework.social.linkedin.api.LinkedInDate;
import org.springframework.social.linkedin.api.Location;
import org.springframework.social.linkedin.api.PhoneNumber;
import org.springframework.social.linkedin.api.Position;
import org.springframework.social.linkedin.api.Recommendation;
import org.springframework.social.linkedin.api.Relation;
import org.springframework.social.linkedin.api.TwitterAccount;
import org.springframework.social.linkedin.api.UrlResource;
import org.springframework.social.linkedin.api.impl.json.ConnectionAuthorizationDeserializer;
import org.springframework.social.linkedin.api.impl.json.DeserializationUtils;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;
import org.springframework.social.linkedin.api.impl.json.RecommendationsListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class LinkedInProfileFullMixin
extends LinkedInObjectMixin {
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> positions;
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> threeCurrentPositions;
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> threePastPositions;
    @JsonProperty
    @JsonDeserialize(using=RecommendationsListDeserializer.class)
    List<Recommendation> recommendationsReceived;
    @JsonProperty
    @JsonDeserialize(using=ImAccountListDeserializer.class)
    List<ImAccount> imAccounts;
    @JsonProperty
    @JsonDeserialize(using=TwitterAccountListDeserializer.class)
    List<TwitterAccount> twitterAccounts;
    @JsonProperty
    @JsonDeserialize(using=UrlResourceListDeserializer.class)
    List<UrlResource> memberUrlResources;
    @JsonProperty
    @JsonDeserialize(using=PhoneNumberListDeserializer.class)
    List<PhoneNumber> phoneNumbers;
    @JsonProperty
    @JsonDeserialize(using=SkillListDeserializer.class)
    List<String> skills;
    @JsonProperty
    @JsonDeserialize(using=EducationListDeserializer.class)
    List<Education> educations;
    @JsonProperty(value="summary")
    String summary;
    @JsonProperty
    String proposalComments;
    @JsonProperty
    String specialties;
    @JsonProperty
    int numConnections;
    @JsonProperty
    boolean numConnectionsCapped;
    @JsonProperty
    int numRecommenders;
    @JsonProperty
    String mainAddress;
    @JsonProperty
    String associations;
    @JsonProperty
    Location location;
    @JsonProperty
    String interests;
    @JsonProperty
    String honors;
    @JsonProperty
    int distance;
    @JsonProperty
    LinkedInDate dateOfBirth;
    @JsonProperty
    CurrentShare currentShare;
    @JsonProperty
    Relation relationToViewer;
    @JsonProperty(value="apiStandardProfileRequest")
    @JsonDeserialize(using=ConnectionAuthorizationDeserializer.class)
    ConnectionAuthorization connectionAuthorization;

    @JsonCreator
    LinkedInProfileFullMixin(@JsonProperty(value="id") String id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="headline") String headline, @JsonProperty(value="industry") String industry, @JsonProperty(value="publicProfileUrl") String publicProfileUrl, @JsonProperty(value="siteStandardProfileRequest") UrlResource siteStandardProfileRequest, @JsonProperty(value="pictureUrl") String profilePictureUrl) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SkillListDeserializer
    extends JsonDeserializer<List<String>> {
        private SkillListDeserializer() {
        }

        public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                JsonNode dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values");
                ArrayList<String> skills = new ArrayList<String>();
                if (dataNode != null) {
                    for (JsonNode d : dataNode) {
                        String s = d.path("skill").path("name").textValue();
                        if (s == null) continue;
                        skills.add(s);
                    }
                }
                return skills;
            }
            throw ctxt.mappingException("Expected JSON object");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EducationListDeserializer
    extends JsonDeserializer<List<Education>> {
        private EducationListDeserializer() {
        }

        public List<Education> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<Education>>(){});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PhoneNumberListDeserializer
    extends JsonDeserializer<List<PhoneNumber>> {
        private PhoneNumberListDeserializer() {
        }

        public List<PhoneNumber> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<PhoneNumber>>(){});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UrlResourceListDeserializer
    extends JsonDeserializer<List<UrlResource>> {
        private UrlResourceListDeserializer() {
        }

        public List<UrlResource> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<UrlResource>>(){});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TwitterAccountListDeserializer
    extends JsonDeserializer<List<TwitterAccount>> {
        private TwitterAccountListDeserializer() {
        }

        public List<TwitterAccount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<TwitterAccount>>(){});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImAccountListDeserializer
    extends JsonDeserializer<List<ImAccount>> {
        private ImAccountListDeserializer() {
        }

        public List<ImAccount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<ImAccount>>(){});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PositionListDeserializer
    extends JsonDeserializer<List<Position>> {
        private PositionListDeserializer() {
        }

        public List<Position> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<Position>>(){});
        }
    }
}

