/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import org.springframework.social.linkedin.api.Company;
import org.springframework.social.linkedin.api.LinkedInNetworkUpdate;
import org.springframework.social.linkedin.api.UpdateAction;
import org.springframework.social.linkedin.api.UpdateContent;
import org.springframework.social.linkedin.api.UpdateContentCompany;
import org.springframework.social.linkedin.api.UpdateContentConnection;
import org.springframework.social.linkedin.api.UpdateContentFollow;
import org.springframework.social.linkedin.api.UpdateContentGroup;
import org.springframework.social.linkedin.api.UpdateContentPersonActivity;
import org.springframework.social.linkedin.api.UpdateContentRecommendation;
import org.springframework.social.linkedin.api.UpdateContentShare;
import org.springframework.social.linkedin.api.UpdateContentStatus;
import org.springframework.social.linkedin.api.UpdateContentViral;
import org.springframework.social.linkedin.api.UpdateType;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinkedInNetworkUpdateListDeserializer
extends JsonDeserializer<LinkedInNetworkUpdate> {
    LinkedInNetworkUpdateListDeserializer() {
    }

    public LinkedInNetworkUpdate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new LinkedInModule());
        jp.setCodec((ObjectCodec)mapper);
        JsonNode dataNode = (JsonNode)jp.readValueAs(JsonNode.class);
        if (dataNode != null) {
            LinkedInNetworkUpdate linkedInNetworkUpdate = (LinkedInNetworkUpdate)mapper.reader((TypeReference)new TypeReference<LinkedInNetworkUpdate>(){}).readValue(dataNode);
            UpdateContent updatedContent = null;
            UpdateType type = linkedInNetworkUpdate.getUpdateType();
            JsonNode updatedNode = dataNode.get("updateContent");
            JsonNode person = updatedNode.get("person");
            if (type == UpdateType.MSFC) {
                person = updatedNode.get("companyPersonUpdate").get("person");
            }
            switch (type) {
                case CONN: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentConnection>(){}).readValue(person);
                    break;
                }
                case STAT: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentStatus>(){}).readValue(person);
                    break;
                }
                case JGRP: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentGroup>(){}).readValue(person);
                    break;
                }
                case PREC: 
                case SVPR: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentRecommendation>(){}).readValue(person);
                    break;
                }
                case APPM: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentPersonActivity>(){}).readValue(person);
                    break;
                }
                case MSFC: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentFollow>(){}).readValue(person);
                    break;
                }
                case VIRL: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentViral>(){}).readValue(person);
                    break;
                }
                case SHAR: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentShare>(){}).readValue(person);
                    break;
                }
                case CMPY: {
                    updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentCompany>(){}).readValue(updatedNode);
                    break;
                }
                default: {
                    try {
                        updatedContent = (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContent>(){}).readValue(person);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            try {
                Field f = LinkedInNetworkUpdate.class.getDeclaredField("updateContent");
                f.setAccessible(true);
                f.set(linkedInNetworkUpdate, updatedContent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (type == UpdateType.MSFC) {
                String action = updatedNode.get("companyPersonUpdate").get("action").get("code").asText();
                try {
                    Field f = UpdateContentFollow.class.getDeclaredField("action");
                    f.setAccessible(true);
                    f.set(updatedContent, action);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Company company = (Company)mapper.reader((TypeReference)new TypeReference<Company>(){}).readValue(updatedNode.get("company"));
                try {
                    Field f = UpdateContentFollow.class.getDeclaredField("following");
                    f.setAccessible(true);
                    f.set(updatedContent, company);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (type == UpdateType.VIRL) {
                Field f;
                JsonNode originalUpdate = updatedNode.path("updateAction").path("originalUpdate");
                UpdateAction updateAction = (UpdateAction)mapper.reader((TypeReference)new TypeReference<UpdateAction>(){}).readValue(originalUpdate);
                String code = updatedNode.path("updateAction").path("action").path("code").textValue();
                try {
                    f = UpdateAction.class.getDeclaredField("action");
                    f.setAccessible(true);
                    f.set(updateAction, code);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    f = UpdateContentViral.class.getDeclaredField("updateAction");
                    f.setAccessible(true);
                    f.set(updatedContent, updateAction);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return linkedInNetworkUpdate;
        }
        return null;
    }
}

