/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AbstractAuthenticationTargetUrlRequestHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.social.UserIdSource;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.web.ProviderSignInAttempt;
import org.springframework.social.security.SocialAuthenticationException;
import org.springframework.social.security.SocialAuthenticationFailureHandler;
import org.springframework.social.security.SocialAuthenticationRedirectException;
import org.springframework.social.security.SocialAuthenticationServiceLocator;
import org.springframework.social.security.SocialAuthenticationToken;
import org.springframework.social.security.SocialUserDetails;
import org.springframework.social.security.provider.SocialAuthenticationService;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private SocialAuthenticationServiceLocator authServiceLocator;
    private String signupUrl = "/signup";
    private String connectionAddedRedirectUrl = "/";
    private boolean updateConnections = true;
    private UserIdSource userIdSource;
    private UsersConnectionRepository usersConnectionRepository;
    private SimpleUrlAuthenticationFailureHandler delegateAuthenticationFailureHandler;
    private static final String DEFAULT_FAILURE_URL = "/signin";

    public SocialAuthenticationFilter(AuthenticationManager authManager, UserIdSource userIdSource, UsersConnectionRepository usersConnectionRepository, SocialAuthenticationServiceLocator authServiceLocator) {
        super("/auth");
        this.setAuthenticationManager(authManager);
        this.userIdSource = userIdSource;
        this.usersConnectionRepository = usersConnectionRepository;
        this.authServiceLocator = authServiceLocator;
        this.delegateAuthenticationFailureHandler = new SimpleUrlAuthenticationFailureHandler(DEFAULT_FAILURE_URL);
        super.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SocialAuthenticationFailureHandler((AuthenticationFailureHandler)this.delegateAuthenticationFailureHandler));
    }

    public void setSignupUrl(String signupUrl) {
        this.signupUrl = signupUrl;
    }

    public void setDefaultFailureUrl(String defaultFailureUrl) {
        this.delegateAuthenticationFailureHandler.setDefaultFailureUrl(defaultFailureUrl);
    }

    public void setConnectionAddedRedirectUrl(String connectionAddedRedirectUrl) {
        this.connectionAddedRedirectUrl = connectionAddedRedirectUrl;
    }

    public void setUpdateConnections(boolean updateConnections) {
        this.updateConnections = updateConnections;
    }

    public void setPostLoginUrl(String postLoginUrl) {
        AuthenticationSuccessHandler successHandler = this.getSuccessHandler();
        if (!(successHandler instanceof AbstractAuthenticationTargetUrlRequestHandler)) {
            throw new IllegalStateException("can't set postLoginUrl on unknown successHandler, type is " + successHandler.getClass().getName());
        }
        AbstractAuthenticationTargetUrlRequestHandler h = (AbstractAuthenticationTargetUrlRequestHandler)successHandler;
        h.setDefaultTargetUrl(postLoginUrl);
    }

    public void setPostFailureUrl(String postFailureUrl) {
        AuthenticationFailureHandler failureHandler = this.getFailureHandler();
        if (!(failureHandler instanceof SimpleUrlAuthenticationFailureHandler)) {
            throw new IllegalStateException("can't set postFailureUrl on unknown failureHandler, type is " + failureHandler.getClass().getName());
        }
        SimpleUrlAuthenticationFailureHandler h = (SimpleUrlAuthenticationFailureHandler)failureHandler;
        h.setDefaultFailureUrl(postFailureUrl);
    }

    public UsersConnectionRepository getUsersConnectionRepository() {
        return this.usersConnectionRepository;
    }

    public SocialAuthenticationServiceLocator getAuthServiceLocator() {
        return this.authServiceLocator;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        SocialAuthenticationService<?> authService;
        if (this.detectRejection(request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"A rejection was detected. Failing authentication.");
            }
            throw new SocialAuthenticationException("Authentication failed because user rejected authorization.");
        }
        Authentication auth = null;
        Set<String> authProviders = this.authServiceLocator.registeredAuthenticationProviderIds();
        String authProviderId = this.getRequestedProviderId(request);
        if (!authProviders.isEmpty() && authProviderId != null && authProviders.contains(authProviderId) && (auth = this.attemptAuthService(authService = this.authServiceLocator.getAuthenticationService(authProviderId), request, response)) == null) {
            throw new AuthenticationServiceException("authentication failed");
        }
        return auth;
    }

    protected boolean detectRejection(HttpServletRequest request) {
        Set parameterKeys = request.getParameterMap().keySet();
        return parameterKeys.size() > 0 && !parameterKeys.contains("oauth_token") && !parameterKeys.contains("code") && !parameterKeys.contains("scope");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String providerId = this.getRequestedProviderId(request);
        if (providerId != null) {
            Set<String> authProviders = this.authServiceLocator.registeredAuthenticationProviderIds();
            return authProviders.contains(providerId);
        }
        return false;
    }

    protected Connection<?> addConnection(SocialAuthenticationService<?> authService, String userId, ConnectionData data) {
        List connections;
        HashSet<String> userIdSet = new HashSet<String>();
        userIdSet.add(data.getProviderUserId());
        Set connectedUserIds = this.usersConnectionRepository.findUserIdsConnectedTo(data.getProviderId(), userIdSet);
        if (connectedUserIds.contains(userId)) {
            return null;
        }
        if (!authService.getConnectionCardinality().isMultiUserId() && !connectedUserIds.isEmpty()) {
            return null;
        }
        ConnectionRepository repo = this.usersConnectionRepository.createConnectionRepository(userId);
        if (!authService.getConnectionCardinality().isMultiProviderUserId() && !(connections = repo.findConnections(data.getProviderId())).isEmpty()) {
            return null;
        }
        Connection connection = authService.getConnectionFactory().createConnection(data);
        connection.sync();
        repo.addConnection(connection);
        return connection;
    }

    private Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private Authentication attemptAuthService(SocialAuthenticationService<?> authService, HttpServletRequest request, HttpServletResponse response) throws SocialAuthenticationRedirectException, AuthenticationException {
        SocialAuthenticationToken token = authService.getAuthToken(request, response);
        if (token == null) {
            return null;
        }
        Assert.notNull(token.getConnection());
        Authentication auth = this.getAuthentication();
        if (auth == null || !auth.isAuthenticated()) {
            return this.doAuthentication(authService, request, token);
        }
        this.addConnection(authService, request, token, auth);
        return null;
    }

    private String getRequestedProviderId(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if (!(uri = uri.substring(request.getContextPath().length())).startsWith(this.getFilterProcessesUrl())) {
            return null;
        }
        if ((uri = uri.substring(this.getFilterProcessesUrl().length())).startsWith("/")) {
            return uri.substring(1);
        }
        return null;
    }

    private void addConnection(SocialAuthenticationService<?> authService, HttpServletRequest request, SocialAuthenticationToken token, Authentication auth) {
        String userId = this.userIdSource.getUserId();
        Serializable principal = token.getPrincipal();
        if (userId == null || !(principal instanceof ConnectionData)) {
            return;
        }
        Connection<?> connection = this.addConnection(authService, userId, (ConnectionData)principal);
        if (connection != null) {
            String redirectUrl = authService.getConnectionAddedRedirectUrl(request, connection);
            if (redirectUrl == null) {
                redirectUrl = this.connectionAddedRedirectUrl;
            }
            throw new SocialAuthenticationRedirectException(redirectUrl);
        }
    }

    private Authentication doAuthentication(SocialAuthenticationService<?> authService, HttpServletRequest request, SocialAuthenticationToken token) {
        try {
            if (!authService.getConnectionCardinality().isAuthenticatePossible()) {
                return null;
            }
            token.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            Authentication success = this.getAuthenticationManager().authenticate((Authentication)token);
            Assert.isInstanceOf(SocialUserDetails.class, (Object)success.getPrincipal(), (String)"unexpected principle type");
            this.updateConnections(authService, token, success);
            return success;
        }
        catch (BadCredentialsException e) {
            if (this.signupUrl != null) {
                this.addSignInAttempt(request.getSession(), token.getConnection());
                throw new SocialAuthenticationRedirectException(this.buildSignupUrl(request));
            }
            throw e;
        }
    }

    private String buildSignupUrl(HttpServletRequest request) {
        if (this.signupUrl.startsWith("http://") || this.signupUrl.startsWith("https://")) {
            return this.signupUrl;
        }
        if (!this.signupUrl.startsWith("/")) {
            return ServletUriComponentsBuilder.fromContextPath((HttpServletRequest)request).path("/" + this.signupUrl).build().toUriString();
        }
        return ServletUriComponentsBuilder.fromContextPath((HttpServletRequest)request).path(this.signupUrl).build().toUriString();
    }

    private void updateConnections(SocialAuthenticationService<?> authService, SocialAuthenticationToken token, Authentication success) {
        if (this.updateConnections) {
            String userId = ((SocialUserDetails)success.getPrincipal()).getUserId();
            Connection<?> connection = token.getConnection();
            ConnectionRepository repo = this.getUsersConnectionRepository().createConnectionRepository(userId);
            repo.updateConnection(connection);
        }
    }

    private void addSignInAttempt(HttpSession session, Connection<?> connection) {
        session.setAttribute(ProviderSignInAttempt.SESSION_ATTRIBUTE, (Object)new ProviderSignInAttempt(connection, (ConnectionFactoryLocator)this.authServiceLocator, this.usersConnectionRepository));
    }
}

