/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.security.provider;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.social.oauth1.OAuth1Version;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.security.SocialAuthenticationRedirectException;
import org.springframework.social.security.SocialAuthenticationToken;
import org.springframework.social.security.provider.AbstractSocialAuthenticationService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth1AuthenticationService<S>
extends AbstractSocialAuthenticationService<S>
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String OAUTH_TOKEN_ATTRIBUTE = "oauthToken";
    private Set<String> returnToUrlParameters;
    private OAuth1ConnectionFactory<S> connectionFactory;

    public OAuth1AuthenticationService(OAuth1ConnectionFactory<S> connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    @Override
    public OAuth1ConnectionFactory<S> getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(OAuth1ConnectionFactory<S> connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setReturnToUrlParameters(Set<String> returnToUrlParameters) {
        Assert.notNull(returnToUrlParameters, (String)"returnToUrlParameters cannot be null");
        this.returnToUrlParameters = returnToUrlParameters;
    }

    public Set<String> getReturnToUrlParameters() {
        if (this.returnToUrlParameters == null) {
            this.returnToUrlParameters = new HashSet<String>();
        }
        return this.returnToUrlParameters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull(this.getConnectionFactory(), (String)"connectionFactory");
    }

    @Override
    public SocialAuthenticationToken getAuthToken(HttpServletRequest request, HttpServletResponse response) throws SocialAuthenticationRedirectException {
        String verifier = request.getParameter("oauth_verifier");
        if (!StringUtils.hasText((String)verifier)) {
            OAuth1Parameters params;
            OAuth1Operations ops = this.getConnectionFactory().getOAuthOperations();
            String returnToUrl = this.buildReturnToUrl(request);
            OAuthToken requestToken = ops.fetchRequestToken(returnToUrl, null);
            request.getSession().setAttribute(OAUTH_TOKEN_ATTRIBUTE, (Object)requestToken);
            if (ops.getVersion() == OAuth1Version.CORE_10) {
                params = new OAuth1Parameters();
                params.setCallbackUrl(returnToUrl);
            } else {
                params = OAuth1Parameters.NONE;
            }
            throw new SocialAuthenticationRedirectException(ops.buildAuthenticateUrl(requestToken.getValue(), params));
        }
        OAuthToken requestToken = this.extractCachedRequestToken(request);
        if (requestToken == null) {
            this.logger.warn((Object)"requestToken unavailable for oauth_verifier");
            return null;
        }
        OAuthToken accessToken = this.getConnectionFactory().getOAuthOperations().exchangeForAccessToken(new AuthorizedRequestToken(requestToken, verifier), null);
        Connection connection = this.getConnectionFactory().createConnection(accessToken);
        return new SocialAuthenticationToken(connection, null);
    }

    protected String buildReturnToUrl(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        sb.append("?");
        for (String name : this.getReturnToUrlParameters()) {
            String value = request.getParameter(name);
            if (value == null) continue;
            sb.append(name).append("=").append(value).append("&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private OAuthToken extractCachedRequestToken(HttpServletRequest request) {
        OAuthToken requestToken = (OAuthToken)request.getSession().getAttribute(OAUTH_TOKEN_ATTRIBUTE);
        request.getSession().removeAttribute(OAUTH_TOKEN_ATTRIBUTE);
        return requestToken;
    }
}

