/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.tripit.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.tripit.api.Trip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
class TripList {
    private final List<Trip> trips;

    @JsonCreator
    public TripList(@JsonProperty(value="Trip") @JsonDeserialize(using=TripListDeserializer.class) List<Trip> trips) {
        this.trips = trips != null ? trips : Collections.emptyList();
    }

    public List<Trip> getList() {
        return this.trips;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TripListDeserializer
    extends JsonDeserializer<List<Trip>> {
        private TripListDeserializer() {
        }

        public List<Trip> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setDeserializationConfig(ctxt.getConfig());
            JsonNode tree = jp.readValueAsTree();
            if (tree.asToken() == JsonToken.START_OBJECT) {
                return Collections.singletonList(objectMapper.readValue(tree, Trip.class));
            }
            if (tree.asToken() == JsonToken.START_ARRAY) {
                ArrayList<Trip> trips = new ArrayList<Trip>(tree.size());
                Iterator iterator = tree.getElements();
                while (iterator.hasNext()) {
                    trips.add((Trip)objectMapper.readValue((JsonNode)iterator.next(), Trip.class));
                }
                return trips;
            }
            return Collections.emptyList();
        }
    }
}

