/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.tripit.api.impl;

import java.io.IOException;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.tripit.api.TripItProfile;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=TripItProfileDeserializer.class)
class TripitProfileMixin {
    TripitProfileMixin() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TripItProfileDeserializer
    extends JsonDeserializer<TripItProfile> {
        TripItProfileDeserializer() {
        }

        public TripItProfile deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            JsonNode profileNode = tree.get("Profile");
            String id = profileNode.get("@attributes").get("ref").getValueAsText();
            String screenName = profileNode.get("screen_name").getValueAsText();
            String publicDisplayName = profileNode.get("public_display_name").getValueAsText();
            String emailAddress = this.getEmailAddress(profileNode);
            String homeCity = this.getTextNodeValue(profileNode, "home_city");
            String company = this.getTextNodeValue(profileNode, "company");
            String profilePath = profileNode.get("profile_url").getValueAsText();
            String profileImageUrl = this.getTextNodeValue(profileNode, "photo_url");
            return new TripItProfile(id, screenName, publicDisplayName, emailAddress, homeCity, company, profilePath, profileImageUrl);
        }

        private String getTextNodeValue(JsonNode parentNode, String nodeName) {
            return parentNode.has(nodeName) ? parentNode.get(nodeName).getValueAsText() : null;
        }

        private String getEmailAddress(JsonNode profileNode) {
            JsonNode emailsNode = profileNode.get("ProfileEmailAddresses").get("ProfileEmailAddress");
            if (emailsNode.asToken() == JsonToken.START_OBJECT) {
                return emailsNode.get("address").getValueAsText();
            }
            if (emailsNode.asToken() == JsonToken.START_ARRAY) {
                Iterator iterator = emailsNode.getElements();
                while (iterator.hasNext()) {
                    JsonNode emailNode = (JsonNode)iterator.next();
                    if (!emailNode.get("is_primary").getValueAsBoolean()) continue;
                    return emailNode.get("address").getValueAsText();
                }
            }
            return null;
        }
    }
}

