/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter;

import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.social.AccountNotConnectedException;
import org.springframework.social.OperationNotPermittedException;
import org.springframework.social.ResponseStatusCodeTranslator;
import org.springframework.social.SocialException;
import org.springframework.social.twitter.DuplicateTweetException;
import org.springframework.social.twitter.InvalidMessageRecipientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterResponseStatusCodeTranslator
implements ResponseStatusCodeTranslator {
    static final String INVALID_MESSAGE_RECIPIENT_TEXT = "You cannot send messages to users who are not following you.";
    static final String DUPLICATE_STATUS_TEXT = "Status is a duplicate.";

    public SocialException translate(ResponseEntity<?> responseEntity) {
        if (!(responseEntity.getBody() instanceof Map)) {
            return null;
        }
        Map body = (Map)responseEntity.getBody();
        if (!body.containsKey("error")) {
            return null;
        }
        String errorText = (String)body.get("error");
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode.equals((Object)HttpStatus.FORBIDDEN)) {
            if (errorText.equals(DUPLICATE_STATUS_TEXT) || errorText.contains("You already said that")) {
                return new DuplicateTweetException(errorText);
            }
            if (errorText.equals(INVALID_MESSAGE_RECIPIENT_TEXT)) {
                return new InvalidMessageRecipientException(errorText);
            }
            return new OperationNotPermittedException(errorText);
        }
        if (statusCode.equals((Object)HttpStatus.UNAUTHORIZED)) {
            return new AccountNotConnectedException(errorText);
        }
        return null;
    }
}

