/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.social.ResponseStatusCodeTranslator;
import org.springframework.social.SocialException;
import org.springframework.social.oauth1.ProtectedResourceClientFactory;
import org.springframework.social.twitter.DirectMessage;
import org.springframework.social.twitter.SearchResults;
import org.springframework.social.twitter.StatusDetails;
import org.springframework.social.twitter.Tweet;
import org.springframework.social.twitter.TwitterApi;
import org.springframework.social.twitter.TwitterErrorHandler;
import org.springframework.social.twitter.TwitterProfile;
import org.springframework.social.twitter.TwitterResponseStatusCodeTranslator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterTemplate
implements TwitterApi {
    private final RestTemplate restTemplate;
    private final ResponseStatusCodeTranslator statusCodeTranslator;
    private DateFormat searchDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private DateFormat timelineDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss ZZZZZ yyyy", Locale.ENGLISH);
    static final int DEFAULT_RESULTS_PER_PAGE = 50;
    static final String API_URL_BASE = "https://api.twitter.com/1/";
    static final String SEARCH_API_URL_BASE = "https://search.twitter.com";
    static final String VERIFY_CREDENTIALS_URL = "https://api.twitter.com/1/account/verify_credentials.json";
    static final String USER_PROFILE_URL = "https://api.twitter.com/1/users/show.json";
    static final String FRIENDS_STATUSES_URL = "https://api.twitter.com/1/statuses/friends.json?screen_name={screen_name}";
    static final String SEARCH_URL = "https://search.twitter.com/search.json?q={query}&rpp={rpp}&page={page}";
    static final String TWEET_URL = "https://api.twitter.com/1/statuses/update.json";
    static final String RETWEET_URL = "https://api.twitter.com/1//statuses/retweet/{tweet_id}.json";
    static final String MENTIONS_URL = "https://api.twitter.com/1/statuses/mentions.json";
    static final String DIRECT_MESSAGES_URL = "https://api.twitter.com/1/direct_messages.json";
    static final String SEND_DIRECT_MESSAGE_URL = "https://api.twitter.com/1/direct_messages/new.json";
    static final String PUBLIC_TIMELINE_URL = "https://api.twitter.com/1/statuses/public_timeline.json";
    static final String HOME_TIMELINE_URL = "https://api.twitter.com/1/statuses/home_timeline.json";
    static final String FRIENDS_TIMELINE_URL = "https://api.twitter.com/1/statuses/friends_timeline.json";
    static final String USER_TIMELINE_URL = "https://api.twitter.com/1/statuses/user_timeline.json";

    public TwitterTemplate() {
        this.restTemplate = new RestTemplate();
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new TwitterErrorHandler());
        this.statusCodeTranslator = new TwitterResponseStatusCodeTranslator();
    }

    public TwitterTemplate(String apiKey, String apiSecret, String accessToken, String accessTokenSecret) {
        this.restTemplate = ProtectedResourceClientFactory.create((String)apiKey, (String)apiSecret, (String)accessToken, (String)accessTokenSecret);
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new TwitterErrorHandler());
        this.statusCodeTranslator = new TwitterResponseStatusCodeTranslator();
    }

    @Override
    public String getProfileId() {
        Map response = (Map)this.restTemplate.getForObject(VERIFY_CREDENTIALS_URL, Map.class, new Object[0]);
        return (String)response.get("screen_name");
    }

    @Override
    public TwitterProfile getUserProfile() {
        return this.getUserProfile(this.getProfileId());
    }

    @Override
    public TwitterProfile getUserProfile(String screenName) {
        Map response = (Map)this.restTemplate.getForObject("https://api.twitter.com/1/users/show.json?screen_name={screenName}", Map.class, new Object[]{screenName});
        return this.getProfileFromResponseMap(response);
    }

    @Override
    public TwitterProfile getUserProfile(long userId) {
        Map response = (Map)this.restTemplate.getForObject("https://api.twitter.com/1/users/show.json?user_id={userId}", Map.class, new Object[]{userId});
        return this.getProfileFromResponseMap(response);
    }

    private TwitterProfile getProfileFromResponseMap(Map<?, ?> response) {
        TwitterProfile profile = new TwitterProfile();
        profile.setId(Long.valueOf(String.valueOf(response.get("id"))));
        profile.setScreenName(String.valueOf(response.get("screen_name")));
        profile.setName(String.valueOf(response.get("name")));
        profile.setDescription(String.valueOf(response.get("description")));
        profile.setLocation(String.valueOf(response.get("location")));
        profile.setUrl(String.valueOf(response.get("url")));
        profile.setProfileImageUrl(String.valueOf(response.get("profile_image_url")));
        profile.setCreatedDate(this.toDate(String.valueOf(response.get("created_at")), this.timelineDateFormat));
        return profile;
    }

    @Override
    public List<String> getFriends(String screenName) {
        List response = (List)this.restTemplate.getForObject(FRIENDS_STATUSES_URL, List.class, Collections.singletonMap("screen_name", screenName));
        ArrayList<String> friends = new ArrayList<String>(response.size());
        for (Map item : response) {
            friends.add((String)item.get("screen_name"));
        }
        return friends;
    }

    @Override
    public void updateStatus(String message) {
        this.updateStatus(message, new StatusDetails());
    }

    @Override
    public void updateStatus(String message, StatusDetails details) {
        LinkedMultiValueMap tweetParams = new LinkedMultiValueMap();
        tweetParams.add((Object)"status", (Object)message);
        tweetParams.setAll(details.toParameterMap());
        ResponseEntity response = this.restTemplate.postForEntity(TWEET_URL, (Object)tweetParams, Map.class, new Object[0]);
        this.handleResponseErrors((ResponseEntity<Map>)response);
    }

    @Override
    public void retweet(long tweetId) {
        ResponseEntity response = this.restTemplate.postForEntity(RETWEET_URL, (Object)"", Map.class, Collections.singletonMap("tweet_id", Long.toString(tweetId)));
        this.handleResponseErrors((ResponseEntity<Map>)response);
    }

    @Override
    public List<Tweet> getMentions() {
        List response;
        List results = response = (List)this.restTemplate.getForObject(MENTIONS_URL, List.class, new Object[0]);
        ArrayList<Tweet> tweets = new ArrayList<Tweet>();
        for (Map item : results) {
            tweets.add(this.populateTweetFromTimelineItem(item));
        }
        return tweets;
    }

    @Override
    public List<DirectMessage> getDirectMessagesReceived() {
        ResponseEntity response = this.restTemplate.getForEntity(DIRECT_MESSAGES_URL, List.class, new Object[0]);
        List results = (List)response.getBody();
        ArrayList<DirectMessage> messages = new ArrayList<DirectMessage>();
        for (Map item : results) {
            DirectMessage message = new DirectMessage();
            message.setId(Long.valueOf(String.valueOf(item.get("id"))));
            message.setText(String.valueOf(item.get("text")));
            message.setSenderId(Long.valueOf(String.valueOf(item.get("sender_id"))));
            message.setSenderScreenName(String.valueOf(item.get("sender_screen_name")));
            message.setRecipientId(Long.valueOf(String.valueOf(item.get("recipient_id"))));
            message.setRecipientScreenName(String.valueOf(item.get("recipient_screen_name")));
            message.setCreatedAt(this.toDate(ObjectUtils.nullSafeToString(item.get("created_at")), this.timelineDateFormat));
            messages.add(message);
        }
        return messages;
    }

    @Override
    public void sendDirectMessage(String toScreenName, String text) {
        LinkedMultiValueMap dmParams = new LinkedMultiValueMap();
        dmParams.add((Object)"screen_name", (Object)toScreenName);
        this.sendDirectMessage(text, (MultiValueMap<String, Object>)dmParams);
    }

    @Override
    public void sendDirectMessage(long toUserId, String text) {
        LinkedMultiValueMap dmParams = new LinkedMultiValueMap();
        dmParams.add((Object)"user_id", (Object)String.valueOf(toUserId));
        this.sendDirectMessage(text, (MultiValueMap<String, Object>)dmParams);
    }

    private void sendDirectMessage(String text, MultiValueMap<String, Object> dmParams) {
        dmParams.add((Object)"text", (Object)text);
        ResponseEntity response = this.restTemplate.postForEntity(SEND_DIRECT_MESSAGE_URL, dmParams, Map.class, new Object[0]);
        this.handleResponseErrors((ResponseEntity<Map>)response);
    }

    @Override
    public List<Tweet> getPublicTimeline() {
        List response = (List)this.restTemplate.getForObject(PUBLIC_TIMELINE_URL, List.class, new Object[0]);
        return this.extractTimelineTweetsFromResponse(response);
    }

    @Override
    public List<Tweet> getHomeTimeline() {
        List response = (List)this.restTemplate.getForObject(HOME_TIMELINE_URL, List.class, new Object[0]);
        return this.extractTimelineTweetsFromResponse(response);
    }

    @Override
    public List<Tweet> getFriendsTimeline() {
        List response = (List)this.restTemplate.getForObject(FRIENDS_TIMELINE_URL, List.class, new Object[0]);
        return this.extractTimelineTweetsFromResponse(response);
    }

    @Override
    public List<Tweet> getUserTimeline() {
        List response = (List)this.restTemplate.getForObject(USER_TIMELINE_URL, List.class, new Object[0]);
        return this.extractTimelineTweetsFromResponse(response);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName) {
        List response = (List)this.restTemplate.getForObject("https://api.twitter.com/1/statuses/user_timeline.json?screen_name={screenName}", List.class, new Object[]{screenName});
        return this.extractTimelineTweetsFromResponse(response);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId) {
        List response = (List)this.restTemplate.getForObject("https://api.twitter.com/1/statuses/user_timeline.json?user_id={userId}", List.class, new Object[]{userId});
        return this.extractTimelineTweetsFromResponse(response);
    }

    @Override
    public SearchResults search(String query) {
        return this.search(query, 1, 50, 0, 0);
    }

    @Override
    public SearchResults search(String query, int page, int resultsPerPage) {
        return this.search(query, page, resultsPerPage, 0, 0);
    }

    @Override
    public SearchResults search(String query, int page, int resultsPerPage, int sinceId, int maxId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", query);
        parameters.put("rpp", String.valueOf(resultsPerPage));
        parameters.put("page", String.valueOf(page));
        String searchUrl = SEARCH_URL;
        if (sinceId > 0) {
            searchUrl = searchUrl + "&since_id={since}";
            parameters.put("since", String.valueOf(sinceId));
        }
        if (maxId > 0) {
            searchUrl = searchUrl + "&max_id={max}";
            parameters.put("max", String.valueOf(maxId));
        }
        ResponseEntity response = this.restTemplate.getForEntity(searchUrl, Map.class, parameters);
        Map resultsMap = (Map)response.getBody();
        List items = (List)resultsMap.get("results");
        ArrayList<Tweet> tweets = new ArrayList<Tweet>(resultsMap.size());
        for (Map item : items) {
            tweets.add(this.populateTweetFromSearchResults(item));
        }
        return this.buildSearchResults(resultsMap, tweets);
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    private SearchResults buildSearchResults(Map<String, Object> response, List<Tweet> tweets) {
        Integer maxId = response.containsKey("max_id") ? (Number)((Number)response.get("max_id")) : (Number)0;
        Integer sinceId = response.containsKey("since_id") ? (Number)((Number)response.get("since_id")) : (Number)0;
        return new SearchResults(tweets, ((Number)maxId).longValue(), ((Number)sinceId).longValue(), response.get("next_page") == null);
    }

    private List<Tweet> extractTimelineTweetsFromResponse(List response) {
        List results = response;
        ArrayList<Tweet> tweets = new ArrayList<Tweet>();
        for (Map item : results) {
            tweets.add(this.populateTweetFromTimelineItem(item));
        }
        return tweets;
    }

    private Tweet populateTweetFromTimelineItem(Map<String, Object> item) {
        Tweet tweet = new Tweet();
        tweet.setId(Long.valueOf(String.valueOf(item.get("id"))));
        tweet.setText(String.valueOf(item.get("text")));
        tweet.setFromUser(String.valueOf(((Map)item.get("user")).get("screen_name")));
        tweet.setFromUserId(Long.valueOf(String.valueOf(((Map)item.get("user")).get("id"))));
        tweet.setProfileImageUrl(String.valueOf(((Map)item.get("user")).get("profile_image_url")));
        tweet.setSource(String.valueOf(item.get("source")));
        Object toUserId = item.get("in_reply_to_user_id");
        tweet.setToUserId(toUserId != null ? Long.valueOf(String.valueOf(toUserId)) : null);
        tweet.setCreatedAt(this.toDate(ObjectUtils.nullSafeToString((Object)item.get("created_at")), this.timelineDateFormat));
        return tweet;
    }

    private Tweet populateTweetFromSearchResults(Map<String, Object> item) {
        Tweet tweet = new Tweet();
        tweet.setId((Long)NumberUtils.parseNumber((String)ObjectUtils.nullSafeToString((Object)item.get("id")), Long.class));
        tweet.setFromUser(ObjectUtils.nullSafeToString((Object)item.get("from_user")));
        tweet.setText(ObjectUtils.nullSafeToString((Object)item.get("text")));
        tweet.setCreatedAt(this.toDate(ObjectUtils.nullSafeToString((Object)item.get("created_at")), this.searchDateFormat));
        tweet.setFromUserId((Long)NumberUtils.parseNumber((String)ObjectUtils.nullSafeToString((Object)item.get("from_user_id")), Long.class));
        Object toUserId = item.get("to_user_id");
        if (toUserId != null) {
            tweet.setToUserId((Long)NumberUtils.parseNumber((String)ObjectUtils.nullSafeToString((Object)toUserId), Long.class));
        }
        tweet.setLanguageCode(ObjectUtils.nullSafeToString((Object)item.get("iso_language_code")));
        tweet.setProfileImageUrl(ObjectUtils.nullSafeToString((Object)item.get("profile_image_url")));
        tweet.setSource(ObjectUtils.nullSafeToString((Object)item.get("source")));
        return tweet;
    }

    private Date toDate(String dateString, DateFormat dateFormat) {
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private void handleResponseErrors(ResponseEntity<Map> response) {
        SocialException exception = this.statusCodeTranslator.translate(response);
        if (exception != null) {
            throw exception;
        }
    }
}

