/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.web;

import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.social.connect.oauth1.OAuth1ServiceProvider;
import org.springframework.social.connect.support.ConnectionRepository;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.twitter.connect.TwitterServiceProvider;
import org.springframework.social.web.signin.AbstractProviderSigninController;
import org.springframework.social.web.signin.OAuth1ProviderSignInAttempt;
import org.springframework.social.web.signin.ProviderSignInAttempt;
import org.springframework.social.web.signin.SignInService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/signin/twitter"})
public class TwitterSigninController
extends AbstractProviderSigninController {
    private final Provider<? extends OAuth1ServiceProvider<?>> serviceProviderLocator;
    private final TwitterServiceProvider serviceProvider;
    private final String callbackUrl;
    private static final String OAUTH_TOKEN_ATTRIBUTE = "oauthToken";

    @Inject
    public TwitterSigninController(Provider<TwitterServiceProvider> serviceProviderLocator, ConnectionRepository connectionRepository, SignInService signInService, String applicationUrl) {
        super(connectionRepository, signInService);
        this.serviceProviderLocator = serviceProviderLocator;
        this.serviceProvider = (TwitterServiceProvider)((Object)serviceProviderLocator.get());
        this.callbackUrl = applicationUrl + ((RequestMapping)AnnotationUtils.findAnnotation(((Object)((Object)this)).getClass(), RequestMapping.class)).value()[0];
    }

    @RequestMapping(method={RequestMethod.POST})
    public String signin(WebRequest request) {
        OAuthToken requestToken = this.serviceProvider.getOAuthOperations().fetchNewRequestToken(this.callbackUrl);
        request.setAttribute(OAUTH_TOKEN_ATTRIBUTE, (Object)requestToken, 1);
        return "redirect:https://api.twitter.com/oauth/authenticate?oauth_token=" + requestToken.getValue();
    }

    @RequestMapping(method={RequestMethod.GET}, params={"oauth_token"})
    public String oauth1Callback(@RequestParam(value="oauth_token") String token, @RequestParam(value="oauth_verifier") String verifier, WebRequest request) {
        OAuthToken accessToken = this.serviceProvider.getOAuthOperations().exchangeForAccessToken(new AuthorizedRequestToken(this.extractCachedRequestToken(request), verifier));
        Serializable accountId = this.getConnectionRepository().findAccountIdByConnectionAccessToken(this.serviceProvider.getId(), accessToken.getValue());
        if (accountId == null) {
            OAuth1ProviderSignInAttempt signInAttempt = new OAuth1ProviderSignInAttempt(this.serviceProviderLocator, accessToken.getValue(), accessToken.getSecret());
            request.setAttribute(ProviderSignInAttempt.SESSION_ATTRIBUTE, (Object)signInAttempt, 1);
            return "redirect:" + this.getSignupUrl();
        }
        this.getSignInService().signIn(accountId);
        return "redirect:/";
    }

    private OAuthToken extractCachedRequestToken(WebRequest request) {
        OAuthToken requestToken = (OAuthToken)request.getAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        request.removeAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        return requestToken;
    }
}

