/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.net.URI;
import org.springframework.social.MissingAuthorizationException;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractTwitterOperations {
    private final boolean isUserAuthorized;
    private final boolean isAppAuthorized;
    private static final String API_URL_BASE = "https://api.twitter.com/1.1/";
    private static final LinkedMultiValueMap<String, String> EMPTY_PARAMETERS = new LinkedMultiValueMap();

    public AbstractTwitterOperations(boolean isUserAuthorized, boolean isAppAuthorized) {
        this.isUserAuthorized = isUserAuthorized;
        this.isAppAuthorized = isAppAuthorized;
    }

    protected void requireUserAuthorization() {
        if (!this.isUserAuthorized) {
            throw new MissingAuthorizationException();
        }
    }

    protected void requireAppAuthorization() {
        if (!this.isAppAuthorized) {
            throw new MissingAuthorizationException();
        }
    }

    protected void requireEitherUserOrAppAuthorization() {
        if (!this.isUserAuthorized && !this.isAppAuthorized) {
            throw new MissingAuthorizationException();
        }
    }

    protected URI buildUri(String path) {
        return this.buildUri(path, (MultiValueMap<String, String>)EMPTY_PARAMETERS);
    }

    protected URI buildUri(String path, String parameterName, String parameterValue) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)parameterName, (Object)parameterValue);
        return this.buildUri(path, (MultiValueMap<String, String>)parameters);
    }

    protected URI buildUri(String path, MultiValueMap<String, String> parameters) {
        return URIBuilder.fromUri((String)(API_URL_BASE + path)).queryParams(parameters).build();
    }
}

