/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;

public class MentionEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="screen_name")
    private String screenName;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="indices")
    private int[] indices;

    public MentionEntity(long id, String screenName, String name, int[] indices) {
        this.id = id;
        this.screenName = screenName;
        this.name = name;
        this.indices = indices;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public int[] getIndices() {
        if (this.indices == null || this.indices.length <= 0) {
            return new int[0];
        }
        return this.indices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MentionEntity that = (MentionEntity)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (!Arrays.equals(this.indices, that.indices)) {
            return false;
        }
        return !(this.screenName != null ? !this.screenName.equals(that.screenName) : that.screenName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.screenName != null ? this.screenName.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.indices != null ? Arrays.hashCode(this.indices) : 0);
        return result;
    }
}

