/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api;

import org.springframework.core.io.Resource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TweetData {
    private String message;
    private Long inReplyToStatusId;
    private Float latitude;
    private Float longitude;
    private boolean displayCoordinates;
    private Resource mediaResource;
    private String placeId;

    public TweetData(String message) {
        this.message = message;
    }

    public TweetData inReplyToStatus(long statusId) {
        this.inReplyToStatusId = statusId;
        return this;
    }

    public TweetData atLocation(float longitude, float latitude) {
        this.latitude = Float.valueOf(latitude);
        this.longitude = Float.valueOf(longitude);
        return this;
    }

    public TweetData atPlace(String placeId) {
        this.placeId = placeId;
        return this;
    }

    public TweetData displayCoordinates(boolean displayCoordinates) {
        this.displayCoordinates = displayCoordinates;
        return this;
    }

    public TweetData withMedia(Resource mediaResource) {
        this.mediaResource = mediaResource;
        return this;
    }

    public boolean hasMedia() {
        return this.mediaResource != null;
    }

    public MultiValueMap<String, Object> toUploadMediaParameters() {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (this.mediaResource != null) {
            params.set((Object)"media", (Object)this.mediaResource);
        }
        return params;
    }

    public MultiValueMap<String, Object> toRequestParameters() {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.set((Object)"status", (Object)this.message);
        if (this.inReplyToStatusId != null) {
            params.set((Object)"in_reply_to_status_id", (Object)this.inReplyToStatusId.toString());
        }
        if (this.latitude != null && this.longitude != null) {
            params.set((Object)"lat", (Object)this.latitude.toString());
            params.set((Object)"long", (Object)this.longitude.toString());
        }
        if (this.displayCoordinates) {
            params.set((Object)"display_coordinates", (Object)"true");
        }
        if (this.placeId != null) {
            params.set((Object)"place_id", (Object)this.placeId);
        }
        return params;
    }
}

