/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.web.connect;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.social.connect.ServiceProvider;
import org.springframework.social.connect.ServiceProviderConnection;
import org.springframework.social.connect.oauth1.OAuth1ServiceProvider;
import org.springframework.social.connect.oauth2.OAuth2ServiceProvider;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.web.connect.AccountIdExtractor;
import org.springframework.social.web.connect.ConnectInterceptor;
import org.springframework.social.web.connect.DefaultAccountIdExtractor;
import org.springframework.social.web.connect.ServiceProviderLocator;
import org.springframework.stereotype.Controller;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/connect/"})
public class ConnectController
implements BeanFactoryAware {
    private ServiceProviderLocator serviceProviderLocator;
    private String baseCallbackUrl;
    private MultiValueMap<Class<?>, ConnectInterceptor<?>> interceptors;
    private AccountIdExtractor accountIdExtractor;
    private static final String OAUTH_TOKEN_ATTRIBUTE = "oauthToken";

    public ConnectController(String applicationUrl) {
        this.baseCallbackUrl = applicationUrl + ((RequestMapping)AnnotationUtils.findAnnotation(this.getClass(), RequestMapping.class)).value()[0];
        this.interceptors = new LinkedMultiValueMap();
        this.accountIdExtractor = new DefaultAccountIdExtractor();
    }

    public void setInterceptors(List<ConnectInterceptor<?>> interceptors) {
        for (ConnectInterceptor<?> interceptor : interceptors) {
            this.addInterceptor(interceptor);
        }
    }

    public void addInterceptor(ConnectInterceptor<?> interceptor) {
        Class providerType = GenericTypeResolver.resolveTypeArgument(interceptor.getClass(), ConnectInterceptor.class);
        this.interceptors.add((Object)providerType, interceptor);
    }

    public void setAccountIdExtractor(AccountIdExtractor accountIdExtractor) {
        this.accountIdExtractor = accountIdExtractor;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.serviceProviderLocator = new ServiceProviderLocator((ListableBeanFactory)beanFactory);
    }

    @RequestMapping(value={"{providerId}"}, method={RequestMethod.GET})
    public String connect(@PathVariable String providerId, WebRequest request) {
        if (this.getServiceProvider(providerId).isConnected(this.accountIdExtractor.extractAccountId(request))) {
            return this.baseViewPath(providerId) + "Connected";
        }
        return this.baseViewPath(providerId) + "Connect";
    }

    @RequestMapping(value={"{providerId}"}, method={RequestMethod.POST})
    public String connect(@PathVariable String providerId, @RequestParam(required=false) String scope, WebRequest request) {
        ServiceProvider provider = this.getServiceProvider(providerId);
        this.preConnect(provider, request);
        if (provider instanceof OAuth1ServiceProvider) {
            OAuth1Operations oauth1Ops = ((OAuth1ServiceProvider)provider).getOAuthOperations();
            OAuthToken requestToken = oauth1Ops.fetchNewRequestToken(this.callbackUrl(providerId));
            request.setAttribute(OAUTH_TOKEN_ATTRIBUTE, (Object)requestToken, 1);
            return "redirect:" + oauth1Ops.buildAuthorizeUrl(requestToken.getValue(), this.callbackUrl(providerId));
        }
        return "redirect:" + ((OAuth2ServiceProvider)provider).getOAuthOperations().buildAuthorizeUrl(this.callbackUrl(providerId), scope);
    }

    @RequestMapping(value={"{providerId}"}, method={RequestMethod.GET}, params={"oauth_token"})
    public String oauth1Callback(@PathVariable String providerId, @RequestParam(value="oauth_token") String token, @RequestParam(value="oauth_verifier", required=false) String verifier, WebRequest request) {
        OAuth1ServiceProvider provider = (OAuth1ServiceProvider)this.getServiceProvider(providerId);
        OAuthToken accessToken = provider.getOAuthOperations().exchangeForAccessToken(new AuthorizedRequestToken(this.extractCachedRequestToken(request), verifier));
        ServiceProviderConnection connection = provider.connect(this.accountIdExtractor.extractAccountId(request), accessToken);
        this.postConnect((ServiceProvider<?>)provider, (ServiceProviderConnection<?>)connection, request);
        return "redirect:/connect/" + providerId;
    }

    @RequestMapping(value={"{providerId}"}, method={RequestMethod.GET}, params={"code"})
    public String oauth2Callback(@PathVariable String providerId, @RequestParam(value="code") String code, WebRequest request) {
        OAuth2ServiceProvider provider = (OAuth2ServiceProvider)this.getServiceProvider(providerId);
        AccessGrant accessGrant = provider.getOAuthOperations().exchangeForAccess(code, this.callbackUrl(providerId));
        ServiceProviderConnection connection = provider.connect(this.accountIdExtractor.extractAccountId(request), accessGrant);
        this.postConnect((ServiceProvider<?>)provider, (ServiceProviderConnection<?>)connection, request);
        return "redirect:/connect/" + providerId;
    }

    @RequestMapping(value={"{providerId}"}, method={RequestMethod.DELETE})
    public String disconnect(@PathVariable String providerId, WebRequest request) {
        ServiceProvider provider = this.getServiceProvider(providerId);
        List connections = provider.getConnections(this.accountIdExtractor.extractAccountId(request));
        for (ServiceProviderConnection connection : connections) {
            connection.disconnect();
        }
        return "redirect:/connect/" + providerId;
    }

    private ServiceProvider getServiceProvider(String providerId) {
        return this.serviceProviderLocator.getServiceProvider(providerId);
    }

    private void preConnect(ServiceProvider<?> provider, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(provider)) {
            interceptor.preConnect(provider, request);
        }
    }

    private void postConnect(ServiceProvider<?> provider, ServiceProviderConnection<?> connection, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(provider)) {
            interceptor.postConnect(provider, connection, request);
        }
    }

    private List<ConnectInterceptor<?>> interceptingConnectionsTo(ServiceProvider<?> provider) {
        Class serviceType = GenericTypeResolver.resolveTypeArgument(provider.getClass(), ServiceProvider.class);
        List<ConnectInterceptor<?>> typedInterceptors = (List<ConnectInterceptor<?>>)this.interceptors.get((Object)serviceType);
        if (typedInterceptors == null) {
            typedInterceptors = Collections.emptyList();
        }
        return typedInterceptors;
    }

    private String baseViewPath(String providerId) {
        return "connect/" + providerId;
    }

    private String callbackUrl(String providerId) {
        return this.baseCallbackUrl + providerId;
    }

    private OAuthToken extractCachedRequestToken(WebRequest request) {
        OAuthToken requestToken = (OAuthToken)request.getAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        request.removeAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        return requestToken;
    }
}

